/*
 * Decompiled with CFR 0.152.
 */
package com.github.ithildir.liferay.mobile.windows;

import com.liferay.mobile.sdk.util.LanguageUtil;
import com.liferay.mobile.sdk.util.Validator;
import org.apache.commons.lang.WordUtils;

public class CSharpUtil
extends LanguageUtil {
    public static final String BOOL = "bool";
    public static final String DYNAMIC = "dynamic";
    public static final String IDICTIONARY = "IDictionary<string, object>";
    public static final String IDICTIONARY_STRING = "IDictionary<string, string>";
    public static final String IENUMERABLE = "IEnumerable";
    public static final String JSON_OBJECT_WRAPPER = "JsonObjectWrapper";
    public static final String MAP_STRING = "map<string,string>";
    public static final String OBJECT = "object";
    public static final String STREAM = "Stream";
    private static final String _BLANK = "";

    public String getIEnumerableCastType(String type) {
        String ienumerableCastType;
        if (!this.isArray(type)) {
            return _BLANK;
        }
        if (type.endsWith("[]")) {
            ienumerableCastType = type.substring(0, type.length() - 2);
        } else if (type.startsWith("list<")) {
            ienumerableCastType = type.substring(5, type.length() - 1);
        } else {
            return _BLANK;
        }
        if (!(ienumerableCastType.equals("boolean") || ienumerableCastType.equals("double") || ienumerableCastType.equals("int") || ienumerableCastType.equals("long") || ienumerableCastType.equals("string"))) {
            return _BLANK;
        }
        return this.getType(ienumerableCastType);
    }

    public String getMethodName(String path) {
        String last = this.getMethodURL(path);
        String[] methodName = last.split("-");
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < methodName.length; ++i) {
            String word = this.capitalize(methodName[i]);
            sb.append(word);
        }
        sb.append("Async");
        return sb.toString();
    }

    public String getParameterName(String parameterName) {
        if (parameterName.equals("params")) {
            return '_' + parameterName;
        }
        return parameterName;
    }

    public String getReturnType(String type) {
        if ((type = this.getType(type)).equals("int")) {
            return "long";
        }
        if (type.equals(JSON_OBJECT_WRAPPER)) {
            return DYNAMIC;
        }
        if (type.equals(this.getIEnumerableType(OBJECT))) {
            return this.getIEnumerableType(DYNAMIC);
        }
        return type;
    }

    public String getServicePackageName(String serviceContext) {
        String className = (String)CLASS_NAMES.get(serviceContext);
        if (className == null) {
            className = WordUtils.capitalize((String)serviceContext);
        }
        return className;
    }

    public String getType(String type) {
        if (type.equals("byte[]") || type.equals("double") || type.equals("int") || type.equals("long") || type.equals("string") || type.equals("void")) {
            return type;
        }
        if (this.isArray(type)) {
            String ienumerableCastType = this.getIEnumerableCastType(type);
            if (Validator.isNull((String)ienumerableCastType)) {
                ienumerableCastType = OBJECT;
            }
            return this.getIEnumerableType(ienumerableCastType);
        }
        if (type.equals("boolean")) {
            return BOOL;
        }
        if (type.equals("object<java.io.File>")) {
            return STREAM;
        }
        if (type.equals(MAP_STRING)) {
            return IDICTIONARY_STRING;
        }
        if (type.startsWith("object<")) {
            return JSON_OBJECT_WRAPPER;
        }
        return IDICTIONARY;
    }

    protected String getIEnumerableType(String type) {
        StringBuilder sb = new StringBuilder();
        sb.append(IENUMERABLE);
        sb.append('<');
        sb.append(type);
        sb.append('>');
        return sb.toString();
    }
}

