/*
 * Decompiled with CFR 0.152.
 */
package in.ishankhanna.tinglingsquares;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.animation.PropertyValuesHolder;
import android.content.Context;
import android.util.AttributeSet;
import android.util.Property;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.RelativeLayout;
import in.ishankhanna.tinglingsquares.SquareView;

public class TinglingSquaresView
extends FrameLayout {
    private static int ANIMATION_TIME_BASE = 500;
    private static float LAG_FACTOR = 0.5f;
    private static final long ANIMATION_RESTART_DELAY = 150L;
    private final SquareView[][] squareViews = new SquareView[3][4];
    private Context ctx;
    private int side = 40;
    private int padding = 8;
    private boolean moveFromLeftToRight = true;
    private final ObjectAnimator[] animatorsLeftToRight = new ObjectAnimator[12];
    private final ObjectAnimator[] animatorsRightToLeft = new ObjectAnimator[12];
    private AnimatorSet column1AnimationLTR;
    private AnimatorSet column2AnimationLTR;
    private AnimatorSet column3AnimationLTR;
    private AnimatorSet column4AnimationLTR;
    private AnimatorSet column1AnimationRTL;
    private AnimatorSet column2AnimationRTL;
    private AnimatorSet column3AnimationRTL;
    private AnimatorSet column4AnimationRTL;
    private final AnimatorSet scene1 = new AnimatorSet();
    private final AnimatorSet scene2 = new AnimatorSet();
    private Runnable animationRunnableLeftToRight = new Runnable(){

        @Override
        public void run() {
            TinglingSquaresView.this.scene2.start();
        }
    };
    private Runnable animationRunnableRightToLeft = new Runnable(){

        @Override
        public void run() {
            TinglingSquaresView.this.scene1.start();
        }
    };

    public TinglingSquaresView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.ctx = context;
        this.init();
    }

    public TinglingSquaresView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.ctx = context;
        this.init();
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        int w = this.side * 5 + this.padding * 4 + this.side * 2;
        int h = this.side * 3 + this.padding * 2 + this.side * 2;
        RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(w, h);
        this.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
    }

    public void init() {
        for (int m = 0; m < 3; ++m) {
            for (int n = 0; n < 4; ++n) {
                this.squareViews[m][n] = new SquareView(this.ctx, m, n);
            }
        }
        this.initAnimations();
    }

    public void initAnimations() {
        this.setupLeftToRightAnimators();
        this.setupRightToLeftAnimators();
        this.scene1.playTogether(new Animator[]{this.column1AnimationRTL, this.column2AnimationRTL, this.column3AnimationRTL, this.column4AnimationRTL});
        this.scene2.playTogether(new Animator[]{this.column4AnimationLTR, this.column2AnimationLTR, this.column3AnimationLTR, this.column1AnimationLTR});
    }

    private void setupLeftToRightAnimators() {
        PropertyValuesHolder pvhLeftToRightAnimation = PropertyValuesHolder.ofFloat((Property)View.ROTATION, (float[])new float[]{0.0f, 90.0f});
        int m = 0;
        int n = 0;
        for (int i = 0; i < 12; ++i) {
            this.animatorsLeftToRight[i] = ObjectAnimator.ofPropertyValuesHolder((Object)((Object)this.squareViews[m][n]), (PropertyValuesHolder[])new PropertyValuesHolder[]{pvhLeftToRightAnimation});
            switch (m) {
                case 0: {
                    this.animatorsLeftToRight[i].setDuration((long)ANIMATION_TIME_BASE);
                    break;
                }
                case 1: {
                    this.animatorsLeftToRight[i].setDuration((long)((int)((float)ANIMATION_TIME_BASE * LAG_FACTOR)));
                    break;
                }
                case 2: {
                    this.animatorsLeftToRight[i].setDuration((long)ANIMATION_TIME_BASE);
                }
            }
            if (++n <= 3) continue;
            ++m;
            n = 0;
        }
        this.column4AnimationLTR = new AnimatorSet();
        this.column4AnimationLTR.playTogether(new Animator[]{this.animatorsLeftToRight[3], this.animatorsLeftToRight[7], this.animatorsLeftToRight[11]});
        this.column3AnimationLTR = new AnimatorSet();
        this.column3AnimationLTR.playTogether(new Animator[]{this.animatorsLeftToRight[2], this.animatorsLeftToRight[6], this.animatorsLeftToRight[10]});
        this.column3AnimationLTR.setStartDelay(TinglingSquaresView.getStartDelayForColumn(3, true));
        this.column2AnimationLTR = new AnimatorSet();
        this.column2AnimationLTR.playTogether(new Animator[]{this.animatorsLeftToRight[1], this.animatorsLeftToRight[5], this.animatorsLeftToRight[9]});
        this.column2AnimationLTR.setStartDelay(TinglingSquaresView.getStartDelayForColumn(2, true));
        this.column1AnimationLTR = new AnimatorSet();
        this.column1AnimationLTR.playTogether(new Animator[]{this.animatorsLeftToRight[0], this.animatorsLeftToRight[4], this.animatorsLeftToRight[8]});
        this.column1AnimationLTR.setStartDelay(TinglingSquaresView.getStartDelayForColumn(1, true));
        this.column1AnimationLTR.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                super.onAnimationEnd(animation);
                TinglingSquaresView.this.runAnimation(150L);
            }
        });
    }

    private void setupRightToLeftAnimators() {
        PropertyValuesHolder pvhRightToLeftAnimation = PropertyValuesHolder.ofFloat((Property)View.ROTATION, (float[])new float[]{90.0f, 0.0f});
        int m = 0;
        int n = 0;
        for (int i = 0; i < 12; ++i) {
            this.animatorsRightToLeft[i] = ObjectAnimator.ofPropertyValuesHolder((Object)((Object)this.squareViews[m][n]), (PropertyValuesHolder[])new PropertyValuesHolder[]{pvhRightToLeftAnimation});
            switch (m) {
                case 0: {
                    this.animatorsRightToLeft[i].setDuration((long)ANIMATION_TIME_BASE);
                    break;
                }
                case 1: {
                    this.animatorsRightToLeft[i].setDuration((long)((int)((float)ANIMATION_TIME_BASE * (LAG_FACTOR + 0.25f))));
                    break;
                }
                case 2: {
                    this.animatorsRightToLeft[i].setDuration((long)((int)((float)ANIMATION_TIME_BASE * LAG_FACTOR)));
                }
            }
            if (++n <= 3) continue;
            ++m;
            n = 0;
        }
        this.column4AnimationRTL = new AnimatorSet();
        this.column4AnimationRTL.playTogether(new Animator[]{this.animatorsRightToLeft[3], this.animatorsRightToLeft[7], this.animatorsRightToLeft[11]});
        this.column4AnimationRTL.setStartDelay(TinglingSquaresView.getStartDelayForColumn(4, false));
        this.column4AnimationRTL.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                super.onAnimationEnd(animation);
                TinglingSquaresView.this.runAnimation(75L);
            }
        });
        this.column3AnimationRTL = new AnimatorSet();
        this.column3AnimationRTL.playTogether(new Animator[]{this.animatorsRightToLeft[2], this.animatorsRightToLeft[6], this.animatorsRightToLeft[10]});
        this.column3AnimationRTL.setStartDelay(TinglingSquaresView.getStartDelayForColumn(3, false));
        this.column2AnimationRTL = new AnimatorSet();
        this.column2AnimationRTL.playTogether(new Animator[]{this.animatorsRightToLeft[1], this.animatorsRightToLeft[5], this.animatorsRightToLeft[9]});
        this.column2AnimationRTL.setStartDelay(TinglingSquaresView.getStartDelayForColumn(2, false));
        this.column1AnimationRTL = new AnimatorSet();
        this.column1AnimationRTL.playTogether(new Animator[]{this.animatorsRightToLeft[0], this.animatorsRightToLeft[4], this.animatorsRightToLeft[8]});
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        for (int m = 0; m < 3; ++m) {
            for (int n = 0; n < 4; ++n) {
                this.addView(this.squareViews[m][n]);
            }
        }
    }

    public void runAnimation(long delay) {
        if (this.moveFromLeftToRight) {
            this.moveFromLeftToRight = false;
            this.postDelayed(this.animationRunnableLeftToRight, delay);
        } else {
            this.moveFromLeftToRight = true;
            this.postDelayed(this.animationRunnableRightToLeft, delay);
        }
    }

    public static void setAnimationTimeBase(int animationTimeBase) {
        ANIMATION_TIME_BASE = animationTimeBase;
    }

    public static void setLagFactor(float lagFactor) {
        LAG_FACTOR = lagFactor;
    }

    public static long getStartDelayForColumn(int columnNumber, boolean isLTR) {
        int ADDITIONAL_LAG_REDUCER = -50;
        if (isLTR) {
            columnNumber = 4 - columnNumber;
            ADDITIONAL_LAG_REDUCER = 0;
        }
        return (long)((float)ANIMATION_TIME_BASE * 0.3f * (float)columnNumber) + (long)ADDITIONAL_LAG_REDUCER;
    }
}

