/*
 * Decompiled with CFR 0.152.
 */
package com.github.isabsent.filepicker;

import android.content.Context;
import android.os.Bundle;
import android.os.Environment;
import android.support.annotation.LayoutRes;
import android.support.annotation.NonNull;
import android.support.v4.util.Pair;
import android.support.v7.app.AlertDialog;
import android.text.Spannable;
import android.text.SpannableString;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import com.github.isabsent.filepicker.R;
import com.github.isabsent.filepicker.comparator.FileNameComparator;
import com.github.isabsent.filepicker.entity.Item;
import com.github.isabsent.filepicker.entity.ItemViewHolder;
import com.github.isabsent.filepicker.entity.SimpleFilePickerItem;
import eltos.simpledialogfragment.SimpleDialog;
import eltos.simpledialogfragment.list.AdvancedAdapter;
import eltos.simpledialogfragment.list.CustomListDialog;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class SimpleFilePickerDialog
extends CustomListDialog<SimpleFilePickerDialog> {
    private static final String TAG = "simpleListDialog";
    private static final String COMPOSITE_MODE = "simpleListDialogcompositeMode";
    private static final String PATH_ARRAY = "simpleListDialogpathArray";
    private static final String FOLDER_PATH = "simpleListDialogfolderPath";
    protected static final String DATA_SET = "simpleListDialogdata_set";
    public static final String SELECTED_LABELS = "simpleListDialogselectedLabels";
    public static final String SELECTED_PATHS = "simpleListDialogselectedPaths";
    public static final String SELECTED_SINGLE_LABEL = "simpleListDialogselectedSingleLabel";
    public static final String SELECTED_SINGLE_PATH = "simpleListDialogselectedSinglePath";
    public static final String HIGHLIGHT = "simpleListDialoghighlight";
    private ArrayList<SimpleFilePickerItem> mData;
    private Button deeperButton;
    private Button pickButton;
    private CompositeMode mode;
    private int choiceMode;
    private String folderPath;
    private OnInteractionListener mListener;

    public static SimpleFilePickerDialog build() {
        return new SimpleFilePickerDialog();
    }

    public SimpleFilePickerDialog filterable(boolean enabled, boolean highlight) {
        this.setArg(HIGHLIGHT, highlight);
        return (SimpleFilePickerDialog)super.filterable(enabled);
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (this.getArguments() != null) {
            this.folderPath = this.getArguments().getString(FOLDER_PATH);
            this.mode = CompositeMode.values()[this.getArguments().getInt(COMPOSITE_MODE)];
            this.choiceMode = this.getArguments().getInt("CustomListDialogchoiceMode");
        }
    }

    protected SimpleFilePickerAdapter onCreateAdapter() {
        int layout2;
        switch (this.choiceMode) {
            case 1: {
                layout2 = R.layout.simple_list_item_single_choice;
                break;
            }
            case 2: {
                layout2 = R.layout.simple_list_item_multiple_choice;
                break;
            }
            default: {
                layout2 = R.layout.simple_list_item_1;
            }
        }
        if (this.getArguments() != null) {
            this.mData = this.getArguments().getParcelableArrayList(DATA_SET);
            if (this.mData == null) {
                this.mData = new ArrayList(0);
            }
        }
        return new SimpleFilePickerAdapter(layout2, this.mData, this);
    }

    public void onActivityCreated(Bundle savedInstanceState) {
        super.onActivityCreated(savedInstanceState);
        if (savedInstanceState != null) {
            this.folderPath = savedInstanceState.getString(FOLDER_PATH);
            this.mode = CompositeMode.values()[savedInstanceState.getInt(COMPOSITE_MODE)];
        }
    }

    public void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.putString(FOLDER_PATH, this.folderPath);
        outState.putInt(COMPOSITE_MODE, this.mode.ordinal());
    }

    public void onStart() {
        super.onStart();
        AlertDialog alertDialog = (AlertDialog)this.getDialog();
        if (alertDialog != null) {
            if (SimpleFilePickerDialog.isExternalStorageRoot(this.folderPath)) {
                Button upButton = alertDialog.getButton(-2);
                upButton.setEnabled(false);
            }
            this.deeperButton = alertDialog.getButton(-1);
            this.pickButton = alertDialog.getButton(-3);
            if (ItemMode.ITEM_FILE_ONLY.equals((Object)this.mode.getItemMode())) {
                this.pickButton.setEnabled(false);
            }
            if (this.choiceMode == 11) {
                this.deeperButton.setVisibility(8);
            }
        }
    }

    protected Bundle onResult(int which) {
        Bundle result = super.onResult(which);
        if (result != null) {
            String[] paths;
            switch (which) {
                case -2: {
                    this.showListItemDialog(new File(this.folderPath).getParent());
                    return result;
                }
                case -1: {
                    String selectedPath = this.getPathToGoDeeper(result);
                    if (selectedPath == null) break;
                    this.showListItemDialog(selectedPath);
                    return result;
                }
            }
            ArrayList positions = result.getIntegerArrayList("CustomListDialogselectedPos");
            if (positions != null && positions.isEmpty() && !result.containsKey("CustomListDialogselectedSinglePos") && which == -3) {
                result.putString(SELECTED_SINGLE_PATH, this.folderPath);
                return result;
            }
            if (positions != null && this.getArguments() != null && (paths = this.getArguments().getStringArray(PATH_ARRAY)) != null) {
                ArrayList<String> labels = new ArrayList<String>(positions.size());
                ArrayList<String> selectedPaths = new ArrayList<String>(positions.size());
                for (Integer pos : positions) {
                    labels.add(this.mData.get(pos).toString());
                    selectedPaths.add(paths[pos]);
                }
                result.putStringArrayList(SELECTED_LABELS, labels);
                result.putStringArrayList(SELECTED_PATHS, selectedPaths);
            }
            if (result.containsKey("CustomListDialogselectedSinglePos") && this.getArguments() != null && (paths = this.getArguments().getStringArray(PATH_ARRAY)) != null) {
                int selectedPosition = result.getInt("CustomListDialogselectedSinglePos");
                SimpleFilePickerItem simpleFilePickerItem = this.mData.get(selectedPosition);
                String selectedLabel = simpleFilePickerItem.toString();
                result.putString(SELECTED_SINGLE_LABEL, selectedLabel);
                result.putString(SELECTED_SINGLE_PATH, paths[selectedPosition]);
            }
        }
        return result;
    }

    private String getPathToGoDeeper(Bundle extras) {
        String[] paths;
        if (this.getArguments() != null && (paths = this.getArguments().getStringArray(PATH_ARRAY)) != null) {
            ArrayList selectedPathPositions;
            int selectedPathPosition = extras.getInt("CustomListDialogselectedSinglePos", -1);
            if (selectedPathPosition < 0 && (selectedPathPositions = extras.getIntegerArrayList("CustomListDialogselectedPos")) != null && !selectedPathPositions.isEmpty()) {
                if (selectedPathPositions.size() == 1) {
                    selectedPathPosition = (Integer)selectedPathPositions.iterator().next();
                } else {
                    for (Integer position : selectedPathPositions) {
                        if (new File(paths[position]).isFile()) continue;
                        if (selectedPathPosition >= 0) {
                            selectedPathPosition = -1;
                            break;
                        }
                        selectedPathPosition = position;
                    }
                }
            }
            if (!new File(paths[selectedPathPosition]).isFile()) {
                return paths[selectedPathPosition];
            }
        }
        return null;
    }

    private void showListItemDialog(String path) {
        int titleResId = 0;
        String title = null;
        if (this.getArguments() != null) {
            Object value = this.getArguments().get("simpleDialog.title");
            if (value instanceof String) {
                title = (String)value;
            } else if (value instanceof Integer) {
                titleResId = (Integer)value;
            }
            if (SimpleFilePickerDialog.isPathAcceptable(path)) {
                if (title != null) {
                    this.mListener.showListItemDialog(title, path, this.mode, this.getTag());
                } else if (titleResId > 0) {
                    this.mListener.showListItemDialog(titleResId, path, this.mode, this.getTag());
                }
            }
        }
    }

    private static boolean isPathAcceptable(String path) {
        String rootExternalStoragePath = Environment.getExternalStorageDirectory().getAbsolutePath();
        return path.startsWith(rootExternalStoragePath);
    }

    public SimpleFilePickerDialog path(String folderPath, CompositeMode mode) {
        final ItemMode itemMode = mode.getItemMode();
        File[] items = new File(folderPath).listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return ItemMode.ITEM_FILE_FOLDER.equals((Object)itemMode) || ItemMode.ITEM_FILE_ONLY.equals((Object)itemMode) || file.isDirectory();
            }
        });
        List<File> itemsList = Arrays.asList(items);
        Collections.sort(itemsList, new FileNameComparator(true));
        ArrayList<SimpleFilePickerItem> list = new ArrayList<SimpleFilePickerItem>(items.length);
        int i = 0;
        String[] itemPaths = new String[items.length];
        String[] itemNames = new String[items.length];
        boolean[] isFiles = new boolean[items.length];
        for (File file : itemsList) {
            itemPaths[i] = file.getAbsolutePath();
            itemNames[i] = file.getName();
            isFiles[i] = file.isFile();
            list.add(new SimpleFilePickerItem(new Item(itemNames[i], isFiles[i]), itemNames[i].hashCode()));
            ++i;
        }
        this.choiceMode(mode.getChoiceMode());
        this.setArg(COMPOSITE_MODE, mode.ordinal());
        this.setArg(FOLDER_PATH, folderPath);
        if (this.getArguments() != null) {
            this.getArguments().putParcelableArrayList(DATA_SET, list);
            this.getArguments().putStringArray(PATH_ARRAY, itemPaths);
        }
        return this;
    }

    private void setButtons(boolean isDeeperEnabled, boolean isPickEnabled) {
        this.deeperButton.setVisibility(isDeeperEnabled ? 0 : 8);
        this.deeperButton.setEnabled(isDeeperEnabled);
        if (ItemMode.ITEM_FILE_FOLDER.equals((Object)this.mode.getItemMode()) || ItemMode.ITEM_FILE_ONLY.equals((Object)this.mode.getItemMode())) {
            this.pickButton.setVisibility(isPickEnabled ? 0 : 8);
            this.pickButton.setEnabled(isPickEnabled);
        }
    }

    private static boolean isExternalStorageRoot(String path) {
        String rootExternalStoragePath = Environment.getExternalStorageDirectory().getAbsolutePath();
        return rootExternalStoragePath.equals(path);
    }

    public void onAttach(Context context) {
        super.onAttach(context);
        if (!(context instanceof OnInteractionListener)) {
            throw new RuntimeException(context.toString() + " must implement SimpleListDialogModInteractionListener");
        }
        this.mListener = (OnInteractionListener)context;
    }

    public void onDetach() {
        super.onDetach();
        this.mListener = null;
    }

    public static interface OnInteractionListener
    extends SimpleDialog.OnDialogResultListener {
        public void showListItemDialog(String var1, String var2, CompositeMode var3, String var4);

        public void showListItemDialog(int var1, String var2, CompositeMode var3, String var4);
    }

    public static enum ItemMode {
        ITEM_FILE_ONLY,
        ITEM_FOLDER_ONLY,
        ITEM_FILE_FOLDER;

    }

    public static enum CompositeMode {
        FILE_ONLY_SINGLE_CHOICE(ItemMode.ITEM_FILE_ONLY, 1),
        FILE_ONLY_MULTI_CHOICE(ItemMode.ITEM_FILE_ONLY, 2),
        FILE_ONLY_DIRECT_CHOICE(ItemMode.ITEM_FILE_ONLY, 11),
        FOLDER_ONLY_SINGLE_CHOICE(ItemMode.ITEM_FOLDER_ONLY, 1),
        FOLDER_ONLY_MULTI_CHOICE(ItemMode.ITEM_FOLDER_ONLY, 2),
        FOLDER_ONLY_DIRECT_CHOICE(ItemMode.ITEM_FOLDER_ONLY, 11),
        FILE_OR_FOLDER_SINGLE_CHOICE(ItemMode.ITEM_FILE_FOLDER, 1),
        FILE_AND_FOLDER_MULTI_CHOICE(ItemMode.ITEM_FILE_FOLDER, 2),
        FILE_OR_FOLDER_DIRECT_CHOICE(ItemMode.ITEM_FILE_FOLDER, 11);

        private ItemMode itemMode;
        private int choiceMode;

        private CompositeMode(ItemMode itemMode, int choiceMode) {
            this.itemMode = itemMode;
            this.choiceMode = choiceMode;
        }

        public ItemMode getItemMode() {
            return this.itemMode;
        }

        public int getChoiceMode() {
            return this.choiceMode;
        }
    }

    public static class SimpleFilePickerAdapter
    extends AdvancedAdapter<Item> {
        private SimpleFilePickerDialog mDialog;
        private int mLayout;
        private int choiceMode;
        private ItemMode itemMode;
        private AdvancedAdapter.AdvancedFilter mFilter = new AdvancedAdapter.AdvancedFilter(true, true){

            protected boolean matches(Item object, @NonNull CharSequence constraint) {
                return this.matches(object.toString());
            }
        };

        public SimpleFilePickerAdapter(@LayoutRes int layout2, ArrayList<SimpleFilePickerItem> data, SimpleFilePickerDialog dialog) {
            this.mLayout = layout2;
            this.mDialog = dialog;
            this.choiceMode = this.mDialog.getArguments().getInt("CustomListDialogchoiceMode");
            this.itemMode = CompositeMode.values()[this.mDialog.getArguments().getInt(SimpleFilePickerDialog.COMPOSITE_MODE)].getItemMode();
            ArrayList<Pair> dataAndIds = new ArrayList<Pair>(data.size());
            for (SimpleFilePickerItem simpleFilePickerItem : data) {
                dataAndIds.add(new Pair((Object)simpleFilePickerItem.getItem(), (Object)simpleFilePickerItem.getId()));
            }
            this.setDataAndIds(dataAndIds);
        }

        public AdvancedAdapter.AdvancedFilter getFilter() {
            return this.mFilter;
        }

        public View getView(final int position, View convertView, ViewGroup parent) {
            ItemViewHolder viewHolder;
            if (convertView == null) {
                convertView = LayoutInflater.from((Context)this.mDialog.getContext()).inflate(this.mLayout, parent, false);
                viewHolder = new ItemViewHolder(convertView);
                convertView.setTag((Object)viewHolder);
            } else {
                viewHolder = (ItemViewHolder)convertView.getTag();
            }
            Item item = (Item)this.getItem(position);
            boolean isItemChecked = this.isItemChecked(position);
            Object text = this.mDialog.getArguments().getBoolean(SimpleFilePickerDialog.HIGHLIGHT) ? this.highlight(item.toString(), this.mDialog.getContext()) : new SpannableString((CharSequence)item.toString());
            viewHolder.bind(item, this.choiceMode, isItemChecked, (Spannable)text);
            convertView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    SimpleFilePickerAdapter.this.toggleChecked(position);
                    SimpleFilePickerAdapter.this.notifyDataSetChanged();
                    ArrayList checkedItems = SimpleFilePickerAdapter.this.getCheckedItems();
                    ArrayList<Item> checkedFolders = null;
                    ArrayList<Item> checkedFiles = null;
                    if (!checkedItems.isEmpty()) {
                        checkedFolders = new ArrayList<Item>();
                        checkedFiles = new ArrayList<Item>();
                        for (Item checkedItem : checkedItems) {
                            if (checkedItem.isFile()) {
                                checkedFiles.add(checkedItem);
                                continue;
                            }
                            checkedFolders.add(checkedItem);
                        }
                    }
                    boolean isDirectChoiceMode = SimpleFilePickerAdapter.this.choiceMode == 11;
                    boolean isPickEnabled = false;
                    if (!isDirectChoiceMode) {
                        boolean areItemsChecked;
                        boolean bl = areItemsChecked = checkedItems.size() > 0;
                        if (ItemMode.ITEM_FILE_ONLY.equals((Object)SimpleFilePickerAdapter.this.itemMode)) {
                            boolean areFoldersChecked = checkedFolders != null && checkedFolders.size() > 0;
                            isPickEnabled = !areFoldersChecked && areItemsChecked;
                        } else {
                            isPickEnabled = areItemsChecked;
                        }
                    }
                    if (!isDirectChoiceMode) {
                        boolean isSingleFolderChecked;
                        boolean isDeeperEnabled = isSingleFolderChecked = checkedFolders != null && checkedFolders.size() == 1;
                        SimpleFilePickerAdapter.this.mDialog.setButtons(isDeeperEnabled, isPickEnabled);
                    } else {
                        boolean isSingleItemChecked;
                        boolean bl = isSingleItemChecked = checkedItems.size() == 1;
                        if (isSingleItemChecked) {
                            SimpleFilePickerAdapter.this.mDialog.pressPositiveButton();
                        }
                    }
                }
            });
            return super.getView(position, convertView, parent);
        }
    }
}

