/*
 * Decompiled with CFR 0.152.
 */
package com.github.irshulx.Components;

import android.app.Activity;
import android.content.Context;
import android.view.MotionEvent;
import android.view.View;
import android.view.inputmethod.InputMethodManager;
import android.widget.Toast;
import com.github.irshulx.Components.ComponentsWrapper;
import com.github.irshulx.Components.CustomEditText;
import com.github.irshulx.EditorComponent;
import com.github.irshulx.EditorCore;
import com.github.irshulx.R;
import com.github.irshulx.models.EditorContent;
import com.github.irshulx.models.EditorType;
import com.github.irshulx.models.Node;
import com.github.irshulx.models.RenderType;
import org.jsoup.nodes.Element;

public class DividerExtensions
extends EditorComponent {
    private int dividerLayout = R.layout.tmpl_divider_layout;
    EditorCore editorCore;

    @Override
    public Node getContent(View view) {
        Node node = this.getNodeInstance(view);
        return node;
    }

    @Override
    public String getContentAsHTML(Node node, EditorContent content) {
        return this.componentsWrapper.getHtmlExtensions().getTemplateHtml(EditorType.hr);
    }

    @Override
    public void renderEditorFromState(Node node, EditorContent content) {
        this.insertDivider(content.nodes.indexOf(node));
    }

    @Override
    public Node buildNodeFromHTML(Element element) {
        int count = this.editorCore.getChildCount();
        this.insertDivider(count);
        return null;
    }

    @Override
    public void init(ComponentsWrapper componentsWrapper) {
        this.componentsWrapper = componentsWrapper;
    }

    public DividerExtensions(EditorCore editorCore) {
        super(editorCore);
        this.editorCore = editorCore;
    }

    public void setDividerLayout(int layout2) {
        this.dividerLayout = layout2;
    }

    public void insertDivider(int index) {
        View view = ((Activity)this.editorCore.getContext()).getLayoutInflater().inflate(this.dividerLayout, null);
        view.setTag((Object)this.editorCore.createTag(EditorType.hr));
        if (index == -1) {
            index = this.editorCore.determineIndex(EditorType.hr);
        }
        if (index == 0) {
            Toast.makeText((Context)this.editorCore.getContext(), (CharSequence)"divider cannot be inserted on line zero", (int)0).show();
            return;
        }
        this.editorCore.getParentView().addView(view, index);
        if (this.editorCore.getRenderType() == RenderType.Editor) {
            if (this.editorCore.getControlType(this.editorCore.getParentView().getChildAt(index + 1)) == EditorType.INPUT) {
                CustomEditText customEditText = (CustomEditText)this.editorCore.getChildAt(index + 1);
                this.componentsWrapper.getInputExtensions().removeFocus(customEditText);
            }
            view.setOnTouchListener(new View.OnTouchListener(){

                public boolean onTouch(View view, MotionEvent event) {
                    if (event.getAction() == 1) {
                        int paddingTop = view.getPaddingTop();
                        int paddingBottom = view.getPaddingBottom();
                        int height = view.getHeight();
                        if (event.getY() < (float)paddingTop) {
                            DividerExtensions.this.editorCore.___onViewTouched(0, DividerExtensions.this.editorCore.getParentView().indexOfChild(view));
                        } else if (event.getY() > (float)(height - paddingBottom)) {
                            DividerExtensions.this.editorCore.___onViewTouched(1, DividerExtensions.this.editorCore.getParentView().indexOfChild(view));
                        }
                        return false;
                    }
                    return true;
                }
            });
            View focus = this.editorCore.getActivity().getCurrentFocus();
            if (focus != null) {
                InputMethodManager imm = (InputMethodManager)this.editorCore.getActivity().getSystemService("input_method");
                imm.hideSoftInputFromWindow(view.getWindowToken(), 0);
                if (focus instanceof CustomEditText) {
                    CustomEditText editText = (CustomEditText)focus;
                    editText.clearFocus();
                    this.editorCore.getParentView().requestFocus();
                }
            }
        }
    }

    public boolean deleteHr(int indexOfDeleteItem) {
        View view = this.editorCore.getParentView().getChildAt(indexOfDeleteItem);
        if (view == null || this.editorCore.getControlType(view) == EditorType.hr) {
            this.editorCore.getParentView().removeView(view);
            return true;
        }
        return false;
    }

    public void removeAllDividersBetweenDeletedAndFocusNext(int indexOfDeleteItem, int nextFocusIndex) {
        for (int i = nextFocusIndex; i < indexOfDeleteItem; ++i) {
            if (this.editorCore.getControlType(this.editorCore.getParentView().getChildAt(i)) != EditorType.hr) continue;
            this.editorCore.getParentView().removeViewAt(i);
        }
    }
}

