/*
 * Decompiled with CFR 0.152.
 */
package com.github.irshulx;

import android.app.Activity;
import android.content.Context;
import android.content.SharedPreferences;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Rect;
import android.preference.PreferenceManager;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.Log;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.View;
import android.widget.EditText;
import android.widget.LinearLayout;
import com.github.irshulx.Components.ComponentsWrapper;
import com.github.irshulx.Components.CustomEditText;
import com.github.irshulx.Components.DividerExtensions;
import com.github.irshulx.Components.HTMLExtensions;
import com.github.irshulx.Components.ImageExtensions;
import com.github.irshulx.Components.InputExtensions;
import com.github.irshulx.Components.ListItemExtensions;
import com.github.irshulx.Components.MacroExtensions;
import com.github.irshulx.Components.MapExtensions;
import com.github.irshulx.EditorListener;
import com.github.irshulx.EditorSettings;
import com.github.irshulx.R;
import com.github.irshulx.Utilities.Utilities;
import com.github.irshulx.models.EditorContent;
import com.github.irshulx.models.EditorControl;
import com.github.irshulx.models.EditorTextStyle;
import com.github.irshulx.models.EditorType;
import com.github.irshulx.models.HtmlTag;
import com.github.irshulx.models.Node;
import com.github.irshulx.models.Op;
import com.github.irshulx.models.RenderType;
import java.util.ArrayList;
import java.util.List;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;

public class EditorCore
extends LinearLayout
implements View.OnTouchListener {
    public static final String TAG = "EDITOR";
    private EditorListener listener;
    public final int MAP_MARKER_REQUEST = 20;
    public final int PICK_IMAGE_REQUEST = 1;
    private InputExtensions inputExtensions;
    private ImageExtensions imageExtensions;
    private ListItemExtensions listItemExtensions;
    private DividerExtensions dividerExtensions;
    private HTMLExtensions htmlExtensions;
    private MapExtensions mapExtensions;
    private MacroExtensions macroExtensions;
    private EditorSettings editorSettings;
    private ComponentsWrapper componentsWrapper;

    public EditorCore(Context _context, AttributeSet attrs) {
        super(_context, attrs);
        this.editorSettings = EditorSettings.init(_context, this);
        this.setOrientation(1);
        this.initialize(attrs);
        this.onPostInit();
    }

    private void onPostInit() {
        if (this.getRenderType() == RenderType.Editor) {
            this.setOnTouchListener(this);
        }
    }

    private void initialize(AttributeSet attrs) {
        this.loadStateFromAttrs(attrs);
        this.inputExtensions = new InputExtensions(this);
        this.imageExtensions = new ImageExtensions(this);
        this.listItemExtensions = new ListItemExtensions(this);
        this.dividerExtensions = new DividerExtensions(this);
        this.mapExtensions = new MapExtensions(this);
        this.htmlExtensions = new HTMLExtensions(this);
        this.macroExtensions = new MacroExtensions(this);
        this.componentsWrapper = new ComponentsWrapper.Builder().inputExtensions(this.inputExtensions).htmlExtensions(this.htmlExtensions).dividerExtensions(this.dividerExtensions).imageExtensions(this.imageExtensions).listItemExtensions(this.listItemExtensions).macroExtensions(this.macroExtensions).mapExtensions(this.mapExtensions).build();
        this.macroExtensions.init(this.componentsWrapper);
        this.dividerExtensions.init(this.componentsWrapper);
        this.inputExtensions.init(this.componentsWrapper);
        this.imageExtensions.init(this.componentsWrapper);
        this.listItemExtensions.init(this.componentsWrapper);
        this.mapExtensions.init(this.componentsWrapper);
    }

    public void ___onViewTouched(int hotspot, int viewPosition) {
        if (hotspot == 0) {
            if (!this.inputExtensions.isInputTextAtPosition(viewPosition - 1)) {
                this.inputExtensions.insertEditText(viewPosition, null, null);
            } else {
                Log.d((String)TAG, (String)"not adding another edittext since already an edittext on the top");
            }
        } else if (hotspot == 1) {
            if (!this.inputExtensions.isInputTextAtPosition(viewPosition + 1)) {
                this.inputExtensions.insertEditText(viewPosition + 1, null, null);
            } else {
                Log.d((String)TAG, (String)"not adding another edittext since already an edittext below");
            }
        }
    }

    public void ___onViewTouched(View view, MotionEvent motionEvent) {
        int position = -1;
        for (int i = 0; i < this.getChildCount(); ++i) {
            boolean withinBound = this.isViewInBounds(this.getChildAt(i), motionEvent.getX(), motionEvent.getY());
            if (!withinBound) continue;
            position = i;
        }
        if (position == -1) {
            CustomEditText editText;
            boolean doInsert = true;
            if (this.getControlType(this.getChildAt(this.getChildCount() - 1)) == EditorType.INPUT && TextUtils.isEmpty((CharSequence)(editText = (CustomEditText)this.getChildAt(this.getChildCount() - 1)).getText())) {
                doInsert = false;
            }
            if (doInsert) {
                this.inputExtensions.insertEditText(this.getChildCount(), null, null);
            }
        }
    }

    private boolean isViewInBounds(View view, float x, float y) {
        Rect outRect = new Rect(view.getLeft(), view.getTop(), view.getRight(), view.getBottom());
        return outRect.contains((int)x, (int)y);
    }

    public Activity getActivity() {
        return (Activity)this.editorSettings.context;
    }

    public LinearLayout getParentView() {
        return this.editorSettings.parentView;
    }

    public int getParentChildCount() {
        return this.editorSettings.parentView.getChildCount();
    }

    public RenderType getRenderType() {
        return this.editorSettings.renderType;
    }

    public Resources getResources() {
        return this.editorSettings.resources;
    }

    public View getActiveView() {
        return this.editorSettings.activeView;
    }

    public void setActiveView(View view) {
        this.editorSettings.activeView = view;
    }

    public EditorListener getEditorListener() {
        return this.listener;
    }

    public void setEditorListener(EditorListener _listener) {
        this.listener = _listener;
    }

    protected InputExtensions getInputExtensions() {
        return this.inputExtensions;
    }

    protected ImageExtensions getImageExtensions() {
        return this.imageExtensions;
    }

    protected MapExtensions getMapExtensions() {
        return this.mapExtensions;
    }

    protected HTMLExtensions getHtmlExtensions() {
        return this.htmlExtensions;
    }

    protected ListItemExtensions getListItemExtensions() {
        return this.listItemExtensions;
    }

    protected DividerExtensions getDividerExtensions() {
        return this.dividerExtensions;
    }

    protected MacroExtensions getMacroExtensions() {
        return this.macroExtensions;
    }

    protected String getContentAsSerialized() {
        EditorContent state = this.getContent();
        return this.serializeContent(state);
    }

    protected String getContentAsSerialized(EditorContent state) {
        return this.serializeContent(state);
    }

    protected EditorContent getContentDeserialized(String EditorContentSerialized) {
        EditorContent Deserialized = (EditorContent)this.editorSettings.gson.fromJson(EditorContentSerialized, EditorContent.class);
        return Deserialized;
    }

    protected String serializeContent(EditorContent _state) {
        String serialized = this.editorSettings.gson.toJson((Object)_state);
        return serialized;
    }

    protected EditorContent getContent() {
        if (this.editorSettings.renderType == RenderType.Renderer) {
            Utilities.toastItOut(this.getContext(), "This option only available in editor mode");
            return null;
        }
        int childCount = this.editorSettings.parentView.getChildCount();
        EditorContent editorState = new EditorContent();
        ArrayList<Node> list = new ArrayList<Node>();
        block8: for (int i = 0; i < childCount; ++i) {
            View view = this.editorSettings.parentView.getChildAt(i);
            Node node = this.getNodeInstance(view);
            switch (node.type) {
                case INPUT: {
                    node = this.getInputExtensions().getContent(view);
                    list.add(node);
                    continue block8;
                }
                case img: {
                    node = this.getImageExtensions().getContent(view);
                    list.add(node);
                    continue block8;
                }
                case hr: {
                    node = this.getDividerExtensions().getContent(view);
                    list.add(node);
                    continue block8;
                }
                case ul: 
                case ol: {
                    node = this.getListItemExtensions().getContent(view);
                    list.add(node);
                    continue block8;
                }
                case map: {
                    node = this.getMapExtensions().getContent(view);
                    list.add(node);
                    continue block8;
                }
                case macro: {
                    node = this.getMacroExtensions().getContent(view);
                    list.add(node);
                }
            }
        }
        editorState.nodes = list;
        return editorState;
    }

    protected void renderEditor(EditorContent _state) {
        this.editorSettings.parentView.removeAllViews();
        this.editorSettings.serialRenderInProgress = true;
        for (Node item : _state.nodes) {
            switch (item.type) {
                case INPUT: {
                    this.inputExtensions.renderEditorFromState(item, _state);
                    break;
                }
                case hr: {
                    this.dividerExtensions.renderEditorFromState(item, _state);
                    break;
                }
                case img: {
                    this.imageExtensions.renderEditorFromState(item, _state);
                    break;
                }
                case ul: 
                case ol: {
                    this.getListItemExtensions().renderEditorFromState(item, _state);
                    break;
                }
                case map: {
                    this.mapExtensions.renderEditorFromState(item, _state);
                    break;
                }
                case macro: {
                    this.macroExtensions.renderEditorFromState(item, _state);
                }
            }
        }
        this.editorSettings.serialRenderInProgress = false;
    }

    protected void parseHtml(String htmlString) {
        Document doc = Jsoup.parse((String)htmlString);
        for (Element element : doc.body().children()) {
            String tag;
            if (!HTMLExtensions.matchesTag(element.tagName().toLowerCase()) && !(tag = element.attr("data-tag")).equals("macro")) continue;
            this.buildNodeFromHTML(element);
        }
    }

    private void buildNodeFromHTML(Element element) {
        String macroTag = element.attr("data-tag");
        if (macroTag.equals("macro")) {
            this.macroExtensions.buildNodeFromHTML(element);
            return;
        }
        HtmlTag tag = HtmlTag.valueOf(element.tagName().toLowerCase());
        int count = this.getParentView().getChildCount();
        if ("<br>".equals(element.html().replaceAll("\\s+", "")) || "<br/>".equals(element.html().replaceAll("\\s+", ""))) {
            this.inputExtensions.insertEditText(count, null, null);
            return;
        }
        if ("hr".equals(tag.name()) || "<hr>".equals(element.html().replaceAll("\\s+", "")) || "<hr/>".equals(element.html().replaceAll("\\s+", ""))) {
            this.getDividerExtensions().buildNodeFromHTML(element);
            return;
        }
        switch (tag) {
            case h1: 
            case h2: 
            case h3: 
            case p: {
                this.inputExtensions.buildNodeFromHTML(element);
                break;
            }
            case ul: 
            case ol: {
                this.listItemExtensions.buildNodeFromHTML(element);
                break;
            }
            case img: {
                this.imageExtensions.buildNodeFromHTML(element);
                break;
            }
            case div: {
                String dataTag = element.attr("data-tag");
                if (!dataTag.equals("img")) break;
                this.imageExtensions.buildNodeFromHTML(element);
            }
        }
    }

    protected String getHTMLContent() {
        EditorContent content = this.getContent();
        return this.getHTMLContent(content);
    }

    protected String getHTMLContent(EditorContent content) {
        StringBuilder htmlBlock = new StringBuilder();
        for (Node item : content.nodes) {
            switch (item.type) {
                case INPUT: {
                    String html = this.inputExtensions.getContentAsHTML(item, content);
                    htmlBlock.append(html);
                    break;
                }
                case img: {
                    String imgHtml = this.getImageExtensions().getContentAsHTML(item, content);
                    htmlBlock.append(imgHtml);
                    break;
                }
                case hr: {
                    htmlBlock.append(this.dividerExtensions.getContentAsHTML(item, content));
                    break;
                }
                case map: {
                    String htmlMap = this.mapExtensions.getContentAsHTML(item, content);
                    htmlBlock.append(htmlMap);
                    break;
                }
                case ul: 
                case ol: {
                    htmlBlock.append(this.listItemExtensions.getContentAsHTML(item, content));
                    break;
                }
                case macro: {
                    htmlBlock.append(this.macroExtensions.getContentAsHTML(item, content));
                }
            }
        }
        return htmlBlock.toString();
    }

    protected String getHTMLContent(String editorContentAsSerialized) {
        EditorContent content = this.getContentDeserialized(editorContentAsSerialized);
        return this.getHTMLContent(content);
    }

    protected void renderEditorFromHtml(String content) {
        this.editorSettings.serialRenderInProgress = true;
        this.parseHtml(content);
        this.editorSettings.serialRenderInProgress = false;
    }

    protected void clearAllContents() {
        this.editorSettings.parentView.removeAllViews();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadStateFromAttrs(AttributeSet attributeSet) {
        if (attributeSet == null) {
            return;
        }
        TypedArray a = null;
        try {
            a = this.getContext().obtainStyledAttributes(attributeSet, R.styleable.editor);
            this.editorSettings.placeHolder = a.getString(R.styleable.editor_placeholder);
            this.editorSettings.autoFocus = a.getBoolean(R.styleable.editor_auto_focus, true);
            String renderType = a.getString(R.styleable.editor_render_type);
            this.editorSettings.renderType = TextUtils.isEmpty((CharSequence)renderType) ? RenderType.Editor : (renderType.toLowerCase().equals("renderer") ? RenderType.Renderer : RenderType.Editor);
        }
        finally {
            if (a != null) {
                a.recycle();
            }
        }
    }

    public int determineIndex(EditorType type) {
        int size = this.editorSettings.parentView.getChildCount();
        if (this.editorSettings.renderType == RenderType.Renderer) {
            return size;
        }
        View _view = this.editorSettings.activeView;
        if (_view == null) {
            return size;
        }
        int currentIndex = this.editorSettings.parentView.indexOfChild(_view);
        EditorType tag = this.getControlType(_view);
        if (tag == EditorType.INPUT) {
            int length = ((EditText)this.editorSettings.activeView).getText().length();
            if (length > 0) {
                return type == EditorType.UL_LI || type == EditorType.OL_LI ? currentIndex : currentIndex;
            }
            return currentIndex;
        }
        if (tag == EditorType.UL_LI || tag == EditorType.OL_LI) {
            EditText _text = (EditText)_view.findViewById(R.id.txtText);
            if (_text.getText().length() > 0) {
                // empty if block
            }
            return size;
        }
        return size;
    }

    public boolean containsStyle(List<EditorTextStyle> _Styles, EditorTextStyle style2) {
        for (EditorTextStyle item : _Styles) {
            if (item != style2) continue;
            return true;
        }
        return false;
    }

    public EditorControl updateTagStyle(EditorControl controlTag, EditorTextStyle style2, Op _op) {
        List<EditorTextStyle> styles = controlTag.editorTextStyles;
        if (_op == Op.Delete) {
            int index = styles.indexOf((Object)style2);
            if (index != -1) {
                styles.remove(index);
                controlTag.editorTextStyles = styles;
            }
        } else {
            int index = styles.indexOf((Object)style2);
            if (index == -1) {
                styles.add(style2);
            }
        }
        return controlTag;
    }

    public EditorType getControlType(View _view) {
        if (_view == null) {
            return null;
        }
        EditorControl _control = (EditorControl)_view.getTag();
        return _control.Type;
    }

    public EditorControl getControlTag(View view) {
        if (view == null) {
            return null;
        }
        EditorControl control = (EditorControl)view.getTag();
        return control;
    }

    public EditorControl createTag(EditorType type) {
        EditorControl control = new EditorControl();
        control.Type = type;
        control.editorTextStyles = new ArrayList<EditorTextStyle>();
        switch (type) {
            default: 
        }
        return control;
    }

    public void deleteFocusedPrevious(EditText view) {
        int index = this.editorSettings.parentView.indexOfChild((View)view);
        if (index == 0) {
            return;
        }
        EditorControl contentType = (EditorControl)((View)view.getParent()).getTag();
        if (contentType != null && (contentType.Type == EditorType.OL_LI || contentType.Type == EditorType.UL_LI)) {
            this.listItemExtensions.validateAndRemoveLisNode((View)view, contentType);
            return;
        }
        View toFocus = this.editorSettings.parentView.getChildAt(index - 1);
        EditorControl control = (EditorControl)toFocus.getTag();
        if (control.Type == EditorType.ol || control.Type == EditorType.ul) {
            this.editorSettings.parentView.removeView((View)view);
            this.listItemExtensions.setFocusToList(toFocus, 1);
        } else {
            this.removeParent((View)view);
        }
    }

    public int removeParent(View view) {
        int indexOfDeleteItem = this.editorSettings.parentView.indexOfChild(view);
        View nextItem = null;
        int nextFocusIndex = -1;
        this.editorSettings.parentView.removeView(view);
        Log.d((String)"indexOfDeleteItem", (String)("indexOfDeleteItem : " + indexOfDeleteItem));
        for (int i = 0; i < indexOfDeleteItem; ++i) {
            if (this.getControlType(this.editorSettings.parentView.getChildAt(i)) != EditorType.INPUT) continue;
            nextItem = this.editorSettings.parentView.getChildAt(i);
            nextFocusIndex = i;
        }
        this.dividerExtensions.removeAllDividersBetweenDeletedAndFocusNext(indexOfDeleteItem, nextFocusIndex);
        if (nextItem != null) {
            CustomEditText text = (CustomEditText)nextItem;
            if (text.requestFocus()) {
                text.setSelection(text.getText().length());
            }
            this.editorSettings.activeView = nextItem;
        }
        return indexOfDeleteItem;
    }

    public EditorContent getStateFromString(String content) {
        if (content == null) {
            content = this.getValue("editorState", "");
        }
        EditorContent deserialized = (EditorContent)this.editorSettings.gson.fromJson(content, EditorContent.class);
        return deserialized;
    }

    private String getValue(String Key, String defaultVal) {
        SharedPreferences _Preferences = PreferenceManager.getDefaultSharedPreferences((Context)this.getContext());
        return _Preferences.getString(Key, defaultVal);
    }

    protected void putValue(String Key, String Value) {
        SharedPreferences _Preferences = PreferenceManager.getDefaultSharedPreferences((Context)this.getContext());
        SharedPreferences.Editor editor = _Preferences.edit();
        editor.putString(Key, Value);
        editor.apply();
    }

    private Node getNodeInstance(View view) {
        EditorType type;
        Node node = new Node();
        node.type = type = this.getControlType(view);
        node.content = new ArrayList();
        return node;
    }

    public boolean isLastRow(View view) {
        int index = this.editorSettings.parentView.indexOfChild(view);
        int length = this.editorSettings.parentView.getChildCount();
        return length - 1 == index;
    }

    public boolean onKey(View v, int keyCode, KeyEvent event, CustomEditText editText) {
        if (keyCode != 67) {
            return false;
        }
        if (this.inputExtensions.isEditTextEmpty((EditText)editText)) {
            this.deleteFocusedPrevious((EditText)editText);
            int controlCount = this.getParentChildCount();
            if (controlCount == 1) {
                return this.checkLastControl();
            }
            return false;
        }
        int length = editText.getText().length();
        int selectionStart = editText.getSelectionStart();
        EditorType editorType = this.getControlType(this.editorSettings.activeView);
        if (selectionStart == 0 && length > 0) {
            if (editorType == EditorType.UL_LI || editorType == EditorType.OL_LI) {
                int index = this.listItemExtensions.getIndexOnEditorByEditText(editText);
                if (index == 0) {
                    this.deleteFocusedPrevious((EditText)editText);
                }
            } else {
                int index = this.getParentView().indexOfChild((View)editText);
                if (index == 0) {
                    return false;
                }
                CustomEditText nextFocus = this.inputExtensions.getEditTextPrevious(index);
                if (nextFocus != null) {
                    this.deleteFocusedPrevious((EditText)editText);
                    nextFocus.setText(nextFocus.getText().toString() + editText.getText().toString());
                    nextFocus.setSelection(nextFocus.getText().length());
                }
            }
        }
        return false;
    }

    private boolean checkLastControl() {
        EditorControl control = this.getControlTag(this.getParentView().getChildAt(0));
        if (control == null) {
            return false;
        }
        switch (control.Type) {
            case ul: 
            case ol: {
                this.editorSettings.parentView.removeAllViews();
            }
        }
        return false;
    }

    public boolean isStateFresh() {
        return this.editorSettings.stateFresh;
    }

    public void setStateFresh(boolean stateFresh) {
        this.editorSettings.stateFresh = stateFresh;
    }

    public boolean isSerialRenderInProgress() {
        return this.editorSettings.serialRenderInProgress;
    }

    public void setSerialRenderInProgress(boolean serialRenderInProgress) {
        this.editorSettings.serialRenderInProgress = serialRenderInProgress;
    }

    public String getPlaceHolder() {
        return this.editorSettings.placeHolder;
    }

    public boolean getAutoFucus() {
        return this.editorSettings.autoFocus;
    }

    public boolean onTouch(View view, MotionEvent motionEvent) {
        this.___onViewTouched(view, motionEvent);
        return false;
    }
}

