/*
 * Decompiled with CFR 0.152.
 */
package com.github.irshulx.Components;

import android.widget.TableLayout;
import android.widget.TextView;
import com.github.irshulx.EditorCore;
import com.github.irshulx.models.EditorContent;
import com.github.irshulx.models.EditorTextStyle;
import com.github.irshulx.models.EditorType;
import com.github.irshulx.models.HtmlTag;
import com.github.irshulx.models.Node;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.parser.Tag;

public class HTMLExtensions {
    EditorCore editorCore;

    public HTMLExtensions(EditorCore editorCore) {
        this.editorCore = editorCore;
    }

    public void parseHtml(String htmlString) {
        Document doc = Jsoup.parse((String)htmlString);
        for (Element element : doc.body().children()) {
            if (!HTMLExtensions.matchesTag(element.tagName().toLowerCase())) continue;
            this.buildNode(element);
        }
    }

    private void buildNode(Element element) {
        HtmlTag tag = HtmlTag.valueOf(element.tagName().toLowerCase());
        int count = this.editorCore.getParentView().getChildCount();
        if ("<br>".equals(element.html().replaceAll("\\s+", "")) || "<br/>".equals(element.html().replaceAll("\\s+", ""))) {
            this.editorCore.getInputExtensions().insertEditText(count, null, null);
            return;
        }
        if ("<hr>".equals(element.html().replaceAll("\\s+", "")) || "<hr/>".equals(element.html().replaceAll("\\s+", ""))) {
            this.editorCore.getDividerExtensions().insertDivider();
            return;
        }
        switch (tag) {
            case h1: 
            case h2: 
            case h3: {
                this.RenderHeader(tag, element);
                break;
            }
            case p: {
                String text = element.html();
                this.editorCore.getInputExtensions().insertEditText(count, null, text);
                break;
            }
            case ul: 
            case ol: {
                this.RenderList(tag == HtmlTag.ol, element);
                break;
            }
            case img: {
                this.RenderImage(element);
                break;
            }
            case div: {
                this.renderDiv(element);
            }
        }
    }

    private void renderDiv(Element element) {
        String tag = element.attr("data-tag");
        if (tag.equals("img")) {
            this.RenderImage(element);
        }
    }

    private void RenderImage(Element element) {
        Element img = element.child(0);
        Element descTag = element.child(1);
        String src = img.attr("src");
        String desc = descTag.html();
        int Index = this.editorCore.getParentChildCount();
        this.editorCore.getImageExtensions().executeDownloadImageTask(src, Index, desc);
    }

    private void RenderList(boolean isOrdered, Element element) {
        if (element.children().size() > 0) {
            Element li = element.child(0);
            String text = this.getHtmlSpan(li);
            TableLayout layout2 = this.editorCore.getListItemExtensions().insertList(this.editorCore.getParentChildCount(), isOrdered, text);
            for (int i = 1; i < element.children().size(); ++i) {
                li = element.child(i);
                text = this.getHtmlSpan(li);
                this.editorCore.getListItemExtensions().AddListItem(layout2, isOrdered, text);
            }
        }
    }

    private void RenderHeader(HtmlTag tag, Element element) {
        int count = this.editorCore.getParentView().getChildCount();
        String text = this.getHtmlSpan(element);
        TextView editText = this.editorCore.getInputExtensions().insertEditText(count, null, text);
        EditorTextStyle style2 = tag == HtmlTag.h1 ? EditorTextStyle.H1 : (tag == HtmlTag.h2 ? EditorTextStyle.H2 : EditorTextStyle.H3);
        this.editorCore.getInputExtensions().UpdateTextStyle(style2, editText);
    }

    private String getHtmlSpan(Element element) {
        Element el = new Element(Tag.valueOf((String)"span"), "");
        el.attributes().put("style", element.attr("style"));
        el.html(element.html());
        return el.toString();
    }

    private boolean hasChildren(Element element) {
        return element.getAllElements().size() > 0;
    }

    private static boolean matchesTag(String test) {
        for (HtmlTag tag : HtmlTag.values()) {
            if (!tag.name().equals(test)) continue;
            return true;
        }
        return false;
    }

    private String getTemplateHtml(EditorType child) {
        String template = null;
        switch (child) {
            case INPUT: {
                template = "<{{$tag}} data-tag=\"input\" {{$style}}>{{$content}}</{{$tag}}>";
                break;
            }
            case hr: {
                template = "<hr data-tag=\"hr\"/>";
                break;
            }
            case img: {
                template = "<div data-tag=\"img\"><img src=\"{{$content}}\" /><span class=\"editor-image-subtitle\">{{$desc}}</span></div>";
                break;
            }
            case map: {
                template = "<div data-tag=\"map\"><img src=\"{{$content}}\" /><span text-align:'center'>{{$desc}}</span></div>";
                break;
            }
            case ol: {
                template = "<ol data-tag=\"ol\">{{$content}}</ol>";
                break;
            }
            case ul: {
                template = "<ul data-tag=\"ul\">{{$content}}</ul>";
                break;
            }
            case OL_LI: 
            case UL_LI: {
                template = "<li>{{$content}}</li>";
            }
        }
        return template;
    }

    private String getInputHtml(Node item) {
        boolean isParagraph = true;
        String tmpl = this.getTemplateHtml(EditorType.INPUT);
        String trimmed = Jsoup.parse((String)item.content.get(0)).body().select("p").html();
        if (item.contentStyles.size() > 0) {
            for (EditorTextStyle style2 : item.contentStyles) {
                switch (style2) {
                    case BOLD: {
                        tmpl = tmpl.replace("{{$content}}", "<b>{{$content}}</b>");
                        break;
                    }
                    case BOLDITALIC: {
                        tmpl = tmpl.replace("{{$content}}", "<b><i>{{$content}}</i></b>");
                        break;
                    }
                    case ITALIC: {
                        tmpl = tmpl.replace("{{$content}}", "<i>{{$content}}</i>");
                        break;
                    }
                    case INDENT: {
                        tmpl = tmpl.replace("{{$style}}", "style=\"margin-left:25px\"");
                        break;
                    }
                    case OUTDENT: {
                        tmpl = tmpl.replace("{{$style}}", "style=\"margin-left:0px\"");
                        break;
                    }
                    case H1: {
                        tmpl = tmpl.replace("{{$tag}}", "h1");
                        isParagraph = false;
                        break;
                    }
                    case H2: {
                        tmpl = tmpl.replace("{{$tag}}", "h2");
                        isParagraph = false;
                        break;
                    }
                    case H3: {
                        tmpl = tmpl.replace("{{$tag}}", "h3");
                        isParagraph = false;
                        break;
                    }
                    case NORMAL: {
                        tmpl = tmpl.replace("{{$tag}}", "p");
                        isParagraph = true;
                    }
                }
            }
            if (isParagraph) {
                tmpl = tmpl.replace("{{$tag}}", "p");
            }
            tmpl = tmpl.replace("{{$content}}", trimmed);
            tmpl = tmpl.replace("{{$style}}", "");
            return tmpl;
        }
        tmpl = tmpl.replace("{{$tag}}", "p");
        tmpl = tmpl.replace("{{$content}}", trimmed);
        tmpl = tmpl.replace(" {{$style}}", "");
        return tmpl;
    }

    public String getContentAsHTML() {
        StringBuilder htmlBlock = new StringBuilder();
        EditorContent content = this.editorCore.getContent();
        return this.getContentAsHTML(content);
    }

    public String getContentAsHTML(EditorContent content) {
        StringBuilder htmlBlock = new StringBuilder();
        for (Node item : content.nodes) {
            switch (item.type) {
                case INPUT: {
                    String html = this.getInputHtml(item);
                    htmlBlock.append(html);
                    break;
                }
                case img: {
                    htmlBlock.append(this.getTemplateHtml(item.type).replace("{{$content}}", item.content.get(0)).replace("{{$desc}}", item.content.get(1)));
                    break;
                }
                case hr: {
                    htmlBlock.append(this.getTemplateHtml(item.type));
                    break;
                }
                case map: {
                    htmlBlock.append(this.getTemplateHtml(item.type).replace("{{$content}}", this.editorCore.getMapExtensions().getCordsAsUri(item.content.get(0))).replace("{{$desc}}", item.content.get(1)));
                    break;
                }
                case ol: 
                case ul: {
                    htmlBlock.append(this.getListAsHtml(item));
                }
            }
        }
        return htmlBlock.toString();
    }

    public String getContentAsHTML(String editorContentAsSerialized) {
        EditorContent content = this.editorCore.getContentDeserialized(editorContentAsSerialized);
        return this.getContentAsHTML(content);
    }

    private String getListAsHtml(Node item) {
        int count = item.content.size();
        String tmpl_parent = this.getTemplateHtml(item.type);
        StringBuilder childBlock = new StringBuilder();
        for (int i = 0; i < count; ++i) {
            String tmpl_li = this.getTemplateHtml(item.type == EditorType.ul ? EditorType.UL_LI : EditorType.OL_LI);
            String trimmed = Jsoup.parse((String)item.content.get(i)).body().select("p").html();
            tmpl_li = tmpl_li.replace("{{$content}}", trimmed);
            childBlock.append(tmpl_li);
        }
        tmpl_parent = tmpl_parent.replace("{{$content}}", childBlock.toString());
        return tmpl_parent;
    }
}

