/*
 * Decompiled with CFR 0.152.
 */
package com.github.irshulx.Components;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.view.View;
import android.widget.ImageView;
import com.github.irshulx.Components.CustomEditText;
import com.github.irshulx.EditorCore;
import com.github.irshulx.MapsActivity;
import com.github.irshulx.R;
import com.github.irshulx.models.EditorControl;
import com.github.irshulx.models.EditorType;
import com.github.irshulx.models.RenderType;
import com.squareup.picasso.Picasso;

public class MapExtensions {
    EditorCore editorCore;
    private int mapExtensionTemplate = R.layout.tmpl_image_view;

    public MapExtensions(EditorCore editorCore) {
        this.editorCore = editorCore;
    }

    public void setMapViewTemplate(int drawable2) {
        this.mapExtensionTemplate = drawable2;
    }

    public String getMapStaticImgUri(String cords, int width) {
        StringBuilder builder = new StringBuilder();
        builder.append("http://maps.google.com/maps/api/staticmap?");
        builder.append("size=" + String.valueOf(width) + "x400&zoom=15&sensor=true&markers=" + cords);
        return builder.toString();
    }

    public void insertMap(String cords, String desc, boolean insertEditText) {
        String[] x = cords.split(",");
        String lat = x[0];
        String lng = x[1];
        int[] size = this.editorCore.getUtilitiles().GetScreenDimension();
        int width = size[0];
        final View childLayout = ((Activity)this.editorCore.getContext()).getLayoutInflater().inflate(this.mapExtensionTemplate, null);
        ImageView imageView = (ImageView)childLayout.findViewById(R.id.imageView);
        Picasso.with((Context)this.editorCore.getContext()).load(this.getMapStaticImgUri(String.valueOf(lat) + "," + String.valueOf(lng), width)).into(imageView);
        CustomEditText editText = (CustomEditText)childLayout.findViewById(R.id.desc);
        if (this.editorCore.getRenderType() == RenderType.Renderer) {
            editText.setText(desc);
            editText.setEnabled(false);
        }
        final View btn = childLayout.findViewById(R.id.btn_remove);
        imageView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                btn.setVisibility(0);
            }
        });
        imageView.setOnFocusChangeListener(new View.OnFocusChangeListener(){

            public void onFocusChange(View v, boolean hasFocus) {
                btn.setVisibility(hasFocus ? 0 : 4);
            }
        });
        btn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                MapExtensions.this.editorCore.getParentView().removeView(childLayout);
            }
        });
        EditorControl control = this.editorCore.CreateTag(EditorType.map);
        control.Cords = cords;
        childLayout.setTag((Object)control);
        int Index = this.editorCore.determineIndex(EditorType.map);
        this.editorCore.getParentView().addView(childLayout, Index);
        if (insertEditText) {
            this.editorCore.getInputExtensions().insertEditText(Index + 1, null, null);
        }
    }

    public void loadMapActivity() {
        Intent intent = new Intent(this.editorCore.getContext(), MapsActivity.class);
        ((Activity)this.editorCore.getContext()).startActivityForResult(intent, this.editorCore.MAP_MARKER_REQUEST);
    }

    public CharSequence getCordsAsUri(String s) {
        return this.getMapStaticImgUri(s, 800);
    }
}

