/*
 * Decompiled with CFR 0.152.
 */
package com.github.irshulx;

import android.content.Context;
import android.content.Intent;
import android.location.Location;
import android.os.Bundle;
import android.support.v4.app.FragmentActivity;
import android.view.View;
import android.widget.Toast;
import com.github.irshulx.R;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.location.places.Place;
import com.google.android.gms.location.places.ui.PlaceAutocompleteFragment;
import com.google.android.gms.location.places.ui.PlaceSelectionListener;
import com.google.android.gms.maps.CameraUpdateFactory;
import com.google.android.gms.maps.GoogleMap;
import com.google.android.gms.maps.OnMapReadyCallback;
import com.google.android.gms.maps.SupportMapFragment;
import com.google.android.gms.maps.model.BitmapDescriptorFactory;
import com.google.android.gms.maps.model.CameraPosition;
import com.google.android.gms.maps.model.LatLng;
import com.google.android.gms.maps.model.MarkerOptions;
import java.util.Random;

public class MapsActivity
extends FragmentActivity
implements OnMapReadyCallback {
    private GoogleMap mMap;
    private LatLng SelectedLatLng;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_maps);
        SupportMapFragment mapFragment = (SupportMapFragment)this.getSupportFragmentManager().findFragmentById(R.id.map);
        mapFragment.getMapAsync((OnMapReadyCallback)this);
        this.setUpMapIfNeeded();
        this.buildGoogleApiClient();
        this.findViewById(R.id.btnInsert).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                MapsActivity.this.insertMap();
            }
        });
    }

    private void insertMap() {
        if (this.SelectedLatLng != null) {
            Intent returnIntent = new Intent();
            String result = String.valueOf(this.SelectedLatLng.latitude) + "," + String.valueOf(this.SelectedLatLng.longitude);
            returnIntent.putExtra("cords", result);
            this.setResult(-1, returnIntent);
            this.finish();
        }
    }

    protected synchronized void buildGoogleApiClient() {
        PlaceAutocompleteFragment fragment = (PlaceAutocompleteFragment)this.getFragmentManager().findFragmentById(R.id.place_autocomplete_fragment);
        fragment.setOnPlaceSelectedListener(new PlaceSelectionListener(){

            public void onPlaceSelected(Place place) {
                Context context = MapsActivity.this.getApplicationContext();
                CharSequence text = place.getName();
                int duration = 1;
                Toast toast = Toast.makeText((Context)context, (CharSequence)("Location," + text + " selected"), (int)duration);
                toast.show();
                MapsActivity.this.SelectedLatLng = place.getLatLng();
                MapsActivity.this.mMap.setTrafficEnabled(true);
                CameraPosition cameraPosition = new CameraPosition.Builder().target(MapsActivity.this.SelectedLatLng).zoom(17.0f).bearing(90.0f).tilt(30.0f).build();
                MapsActivity.this.mMap.animateCamera(CameraUpdateFactory.newCameraPosition((CameraPosition)cameraPosition));
                MapsActivity.this.mMap.addMarker(new MarkerOptions().position(MapsActivity.this.SelectedLatLng).title(text.toString()).icon(BitmapDescriptorFactory.fromResource((int)R.drawable.map_marker)));
            }

            public void onError(Status status) {
            }
        });
    }

    private void setUpMapIfNeeded() {
        if (this.mMap == null) {
            ((SupportMapFragment)this.getSupportFragmentManager().findFragmentById(R.id.map)).getMapAsync(new OnMapReadyCallback(){

                public void onMapReady(GoogleMap googleMap) {
                    MapsActivity.this.mMap = googleMap;
                }
            });
        }
    }

    public void onMapReady(GoogleMap googleMap) {
        this.mMap = googleMap;
    }

    public class MapHelper {
        public Location getLocation(Location location, int radius) {
            Random random = new Random();
            double radiusInDegrees = (float)radius / 111000.0f;
            double x0 = location.getLongitude() * 1000000.0;
            double y0 = location.getLatitude() * 1000000.0;
            double u = random.nextInt(1001) / 1000;
            double v = random.nextInt(1001) / 1000;
            double w = radiusInDegrees * Math.sqrt(u);
            double t = Math.PI * 2 * v;
            double x = w * Math.cos(t);
            double y = w * Math.sin(t);
            double new_x = x / Math.cos(y0);
            Location newLocation = new Location("Loc in radius");
            newLocation.setLongitude(new_x + x0);
            newLocation.setLatitude(y + y0);
            return newLocation;
        }
    }
}

