/*
 * Decompiled with CFR 0.152.
 */
package com.github.irshulx;

import android.app.Activity;
import android.content.Context;
import android.content.SharedPreferences;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Point;
import android.text.Editable;
import android.text.Html;
import android.text.Spanned;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.Display;
import android.view.View;
import android.view.ViewGroup;
import android.widget.EditText;
import android.widget.LinearLayout;
import android.widget.TableLayout;
import android.widget.TableRow;
import android.widget.TextView;
import android.widget.Toast;
import com.github.irshulx.Components.DividerExtensions;
import com.github.irshulx.Components.HTMLExtensions;
import com.github.irshulx.Components.ImageExtensions;
import com.github.irshulx.Components.InputExtensions;
import com.github.irshulx.Components.ListItemExtensions;
import com.github.irshulx.Components.MapExtensions;
import com.github.irshulx.Editor;
import com.github.irshulx.R;
import com.github.irshulx.models.EditorContent;
import com.github.irshulx.models.EditorControl;
import com.github.irshulx.models.EditorTextStyle;
import com.github.irshulx.models.EditorType;
import com.github.irshulx.models.Op;
import com.github.irshulx.models.RenderType;
import com.github.irshulx.models.state;
import com.google.gson.Gson;
import java.util.ArrayList;
import java.util.List;

public class EditorCore
extends LinearLayout {
    public String PlaceHolder = null;
    private final String SHAREDPREFERENCE = "QA";
    private Context __context;
    private Activity __activity;
    private LinearLayout __parentView;
    private RenderType __renderType;
    private Resources __resources;
    private View __activeView;
    private Gson __gson;
    private Utilities __utilities;
    private EditorListener __listener;
    public final int MAP_MARKER_REQUEST = 20;
    public final int PICK_IMAGE_REQUEST = 1;
    private String __imageUploaderUri;
    private InputExtensions __inputExtensions;
    private ImageExtensions __imageExtensions;
    private ListItemExtensions __listItemExtensions;
    private DividerExtensions __dividerExtensions;
    private HTMLExtensions __htmlExtensions;
    private MapExtensions __mapExtensions;

    public EditorCore(Context _context, AttributeSet attrs) {
        super(_context, attrs);
        this.__context = _context;
        this.__activity = (Activity)_context;
        this.setOrientation(1);
        this.initialize(_context, attrs);
    }

    private void initialize(Context context, AttributeSet attrs) {
        this.loadStateFromAttrs(attrs);
        this.__utilities = new Utilities();
        this.__resources = context.getResources();
        this.__gson = new Gson();
        this.__inputExtensions = new InputExtensions(this);
        this.__imageExtensions = new ImageExtensions(this);
        this.__imageExtensions.setImageUploadUri(this.__imageUploaderUri);
        this.__listItemExtensions = new ListItemExtensions(this);
        this.__dividerExtensions = new DividerExtensions(this);
        this.__mapExtensions = new MapExtensions(this);
        this.__htmlExtensions = new HTMLExtensions(this);
        this.__parentView = this;
    }

    public Activity getActivity() {
        return this.__activity;
    }

    public LinearLayout getParentView() {
        return this.__parentView;
    }

    public int getParentChildCount() {
        return this.__parentView.getChildCount();
    }

    public RenderType getRenderType() {
        return this.__renderType;
    }

    public Resources getResources() {
        return this.__resources;
    }

    public View getActiveView() {
        return this.__activeView;
    }

    public void setActiveView(View view) {
        this.__activeView = view;
    }

    public Utilities getUtilitiles() {
        return this.__utilities;
    }

    public EditorListener getEditorListener() {
        return this.__listener;
    }

    public void setEditorListener(EditorListener _listener) {
        this.__listener = _listener;
    }

    public InputExtensions getInputExtensions() {
        return this.__inputExtensions;
    }

    public ImageExtensions getImageExtensions() {
        return this.__imageExtensions;
    }

    public MapExtensions getMapExtensions() {
        return this.__mapExtensions;
    }

    public HTMLExtensions getHtmlExtensions() {
        return this.__htmlExtensions;
    }

    public ListItemExtensions getListItemExtensions() {
        return this.__listItemExtensions;
    }

    public DividerExtensions getDividerExtensions() {
        return this.__dividerExtensions;
    }

    public String getImageUploaderUri() {
        return this.__imageUploaderUri;
    }

    public void setImageUploaderUri(String imageUploaderUri) {
        this.__imageUploaderUri = imageUploaderUri;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadStateFromAttrs(AttributeSet attributeSet) {
        if (attributeSet == null) {
            return;
        }
        TypedArray a = null;
        try {
            a = this.getContext().obtainStyledAttributes(attributeSet, R.styleable.editor);
            this.PlaceHolder = a.getString(R.styleable.editor_placeholder);
            String renderType = a.getString(R.styleable.editor_render_type);
            this.__renderType = TextUtils.isEmpty((CharSequence)renderType) ? RenderType.Editor : (renderType.toLowerCase().equals("renderer") ? RenderType.Renderer : RenderType.Editor);
        }
        finally {
            if (a != null) {
                a.recycle();
            }
        }
    }

    public int determineIndex(EditorType type) {
        int size = this.__parentView.getChildCount();
        if (this.__renderType == RenderType.Renderer) {
            return size;
        }
        View _view = this.__activeView;
        if (_view == null) {
            return size;
        }
        int currentIndex = this.__parentView.indexOfChild(_view);
        EditorType tag = this.GetControlType(_view);
        if (tag == EditorType.INPUT) {
            int length = ((EditText)this.__activeView).getText().length();
            if (length > 0) {
                return type == EditorType.UL_LI || type == EditorType.OL_LI ? currentIndex : currentIndex;
            }
            return currentIndex;
        }
        if (tag == EditorType.UL_LI || tag == EditorType.OL_LI) {
            EditText _text = (EditText)_view.findViewById(R.id.txtText);
            if (_text.getText().length() > 0) {
                // empty if block
            }
            return size;
        }
        return size;
    }

    public boolean ContainsStyle(List<EditorTextStyle> _Styles, EditorTextStyle style) {
        for (EditorTextStyle item : _Styles) {
            if (item != style) continue;
            return true;
        }
        return false;
    }

    public EditorControl UpdateTagStyle(EditorControl controlTag, EditorTextStyle style, Op _op) {
        List<EditorTextStyle> styles = controlTag._ControlStyles;
        if (_op == Op.Delete) {
            int index = styles.indexOf((Object)style);
            if (index != -1) {
                styles.remove(index);
                controlTag._ControlStyles = styles;
            }
        } else {
            int index = styles.indexOf((Object)style);
            if (index == -1) {
                styles.add(style);
            }
        }
        return controlTag;
    }

    public EditorType GetControlType(View _view) {
        EditorControl _control = (EditorControl)_view.getTag();
        return _control.Type;
    }

    public EditorControl GetControlTag(View view) {
        EditorControl control = (EditorControl)view.getTag();
        return control;
    }

    public EditorControl CreateTag(EditorType type) {
        EditorControl control = new EditorControl();
        control.Type = type;
        control._ControlStyles = new ArrayList<EditorTextStyle>();
        switch (type) {
            default: 
        }
        return control;
    }

    public void deleteFocusedPrevious(EditText view) {
        String parentTagName = view.getParent().getClass().getName();
        if (parentTagName.toLowerCase().equals("android.widget.tablerow")) {
            TableRow _row = (TableRow)view.getParent();
            TableLayout _table = (TableLayout)_row.getParent();
            int index = _table.indexOfChild((View)_row);
            _table.removeView((View)_row);
            if (index > 0) {
                TableRow focusrow = (TableRow)_table.getChildAt(index - 1);
                EditText text = (EditText)focusrow.findViewById(R.id.txtText);
                if (text.requestFocus()) {
                    text.setSelection(text.getText().length());
                }
            } else {
                this.RemoveParent((View)_table);
            }
        } else {
            this.RemoveParent((View)view);
        }
    }

    public void RemoveParent(View view) {
        int indexOfDeleteItem = this.__parentView.indexOfChild(view);
        View nextItem = null;
        if (indexOfDeleteItem == 0) {
            return;
        }
        this.__dividerExtensions.deleteHr(indexOfDeleteItem - 1);
        for (int i = 0; i < this.__parentView.getChildCount(); ++i) {
            if (i >= indexOfDeleteItem || this.GetControlType(this.__parentView.getChildAt(i)) != EditorType.INPUT) continue;
            nextItem = this.__parentView.getChildAt(i);
        }
        this.__parentView.removeView(view);
        if (nextItem != null) {
            EditText text = (EditText)nextItem;
            String x = text.getText().toString();
            if (text.requestFocus()) {
                text.setSelection(text.getText().length());
            }
            this.__activeView = nextItem;
        }
    }

    public EditorContent getStateFromString(String content) {
        if (content == null) {
            content = this.GetValue("editorState", "");
        }
        EditorContent deserialized = (EditorContent)this.__gson.fromJson(content, EditorContent.class);
        return deserialized;
    }

    public String GetValue(String Key, String defaultVal) {
        SharedPreferences _Preferences = this.__context.getSharedPreferences("QA", 0);
        return _Preferences.getString(Key, defaultVal);
    }

    public void putValue(String Key, String Value) {
        SharedPreferences _Preferences = this.__context.getSharedPreferences("QA", 0);
        SharedPreferences.Editor editor = _Preferences.edit();
        editor.putString(Key, Value);
        editor.apply();
    }

    public String getContentAsSerialized() {
        EditorContent state2 = this.getContent();
        return this.serializeContent(state2);
    }

    public String getContentAsSerialized(EditorContent state2) {
        return this.serializeContent(state2);
    }

    public EditorContent getContentDeserialized(String EditorContentSerialized) {
        EditorContent Deserialized = (EditorContent)this.__gson.fromJson(EditorContentSerialized, EditorContent.class);
        return Deserialized;
    }

    public String serializeContent(EditorContent _state) {
        String serialized = this.__gson.toJson((Object)_state);
        return serialized;
    }

    public EditorContent getContent() {
        if (this.__renderType == RenderType.Renderer) {
            this.__utilities.toastItOut("This option only available in editor mode");
            return null;
        }
        int childCount = this.__parentView.getChildCount();
        EditorContent editorState = new EditorContent();
        ArrayList<state> list = new ArrayList<state>();
        block7: for (int i = 0; i < childCount; ++i) {
            EditorType type;
            state state2 = new state();
            View view = this.__parentView.getChildAt(i);
            state2.type = type = this.GetControlType(view);
            state2.content = new ArrayList();
            switch (type) {
                case INPUT: {
                    EditText _text = (EditText)view;
                    EditorControl tag = (EditorControl)view.getTag();
                    state2._ControlStyles = tag._ControlStyles;
                    state2.content.add(Html.toHtml((Spanned)_text.getText()));
                    list.add(state2);
                    continue block7;
                }
                case img: {
                    EditorControl imgTag = (EditorControl)view.getTag();
                    state2.content.add(imgTag.Path);
                    list.add(state2);
                    continue block7;
                }
                case hr: {
                    list.add(state2);
                    continue block7;
                }
                case ul: 
                case ol: {
                    TableLayout table = (TableLayout)view;
                    int _rowCount = table.getChildCount();
                    for (int j = 0; j < _rowCount; ++j) {
                        View row = table.getChildAt(j);
                        EditText li = (EditText)row.findViewById(R.id.txtText);
                        state2.content.add(Html.toHtml((Spanned)li.getText()));
                    }
                    list.add(state2);
                    continue block7;
                }
                case map: {
                    EditorControl mapTag = (EditorControl)view.getTag();
                    state2.content.add(mapTag.Cords);
                    list.add(state2);
                }
            }
        }
        editorState.stateList = list;
        return editorState;
    }

    public void RenderEditor(EditorContent _state) {
        this.__parentView.removeAllViews();
        block7: for (state item : _state.stateList) {
            switch (item.type) {
                case INPUT: {
                    String text = item.content.get(0);
                    TextView view = this.__inputExtensions.InsertEditText(0, "", text);
                    if (item._ControlStyles == null) break;
                    for (EditorTextStyle style : item._ControlStyles) {
                        this.__inputExtensions.UpdateTextStyle(style, view);
                    }
                    continue block7;
                }
                case hr: {
                    this.__dividerExtensions.InsertDivider();
                    break;
                }
                case img: {
                    String path = item.content.get(0);
                    this.__imageExtensions.loadImage(path);
                    break;
                }
                case ul: 
                case ol: {
                    TableLayout _layout = null;
                    for (int i = 0; i < item.content.size(); ++i) {
                        if (i == 0) {
                            _layout = this.__listItemExtensions.insertList(_state.stateList.indexOf(item), item.type == EditorType.ol, item.content.get(i));
                            continue;
                        }
                        this.__listItemExtensions.AddListItem(_layout, item.type == EditorType.ol, item.content.get(i));
                    }
                    continue block7;
                }
                case map: {
                    this.__mapExtensions.insertMap(item.content.get(0), true);
                }
            }
        }
    }

    public boolean isLastRow(View view) {
        int index = this.__parentView.indexOfChild(view);
        int length = this.__parentView.getChildCount();
        return length - 1 == index;
    }

    public int GetChildCount() {
        int Count = this.__parentView.getChildCount();
        return Count;
    }

    public int GetChildCountforView(View view) {
        return ((ViewGroup)view).getChildCount();
    }

    public void RenderEditorFromHtml(String content) {
        this.__htmlExtensions.parseHtml(content);
    }

    public void clearAllContents() {
        this.__parentView.removeAllViews();
    }

    public void ExpressSetup(final Editor editor) {
        Activity activity = (Activity)this.__context;
        activity.findViewById(R.id.action_h1).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                editor.UpdateTextStyle(EditorTextStyle.H1);
            }
        });
        activity.findViewById(R.id.action_h2).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                editor.UpdateTextStyle(EditorTextStyle.H2);
            }
        });
        activity.findViewById(R.id.action_h3).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                editor.UpdateTextStyle(EditorTextStyle.H3);
            }
        });
        activity.findViewById(R.id.action_bold).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                editor.UpdateTextStyle(EditorTextStyle.BOLD);
            }
        });
        activity.findViewById(R.id.action_Italic).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                editor.UpdateTextStyle(EditorTextStyle.ITALIC);
            }
        });
        activity.findViewById(R.id.action_indent).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                editor.UpdateTextStyle(EditorTextStyle.INDENT);
            }
        });
        activity.findViewById(R.id.action_outdent).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                editor.UpdateTextStyle(EditorTextStyle.OUTDENT);
            }
        });
        activity.findViewById(R.id.action_bulleted).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                editor.InsertList(false);
            }
        });
        activity.findViewById(R.id.action_unordered_numbered).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                editor.InsertList(true);
            }
        });
        activity.findViewById(R.id.action_hr).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                editor.InsertDivider();
            }
        });
        activity.findViewById(R.id.action_insert_image).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                editor.OpenImagePicker();
            }
        });
        activity.findViewById(R.id.action_insert_link).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                editor.InsertLink();
            }
        });
        activity.findViewById(R.id.action_map).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                editor.InsertMap();
            }
        });
        activity.findViewById(R.id.action_erase).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                editor.clearAllContents();
            }
        });
        editor.Render();
    }

    public class Utilities {
        public float PxtoSp(float px) {
            float scaledDensity = ((EditorCore)EditorCore.this).__context.getResources().getDisplayMetrics().scaledDensity;
            float sp = px / scaledDensity;
            return sp;
        }

        public int[] GetScreenDimension() {
            Display display = ((Activity)EditorCore.this.__context).getWindowManager().getDefaultDisplay();
            Point size = new Point();
            display.getSize(size);
            int width = size.x;
            int height = size.y;
            int[] dimen = new int[]{width, height};
            return dimen;
        }

        public void toastItOut(String message) {
            Toast.makeText((Context)EditorCore.this.__context, (CharSequence)message, (int)0).show();
        }
    }

    public static interface EditorListener {
        public void onTextChanged(EditText var1, Editable var2);
    }
}

