/*
 * Decompiled with CFR 0.152.
 */
package io.ipfs.cid;

import io.ipfs.multibase.Multibase;
import io.ipfs.multihash.Multihash;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Map;
import java.util.TreeMap;

public class Cid
extends Multihash {
    public final long version;
    public final Codec codec;
    private static String[] HEX_DIGITS = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "a", "b", "c", "d", "e", "f"};
    private static String[] HEX = new String[256];

    public Cid(long version, Codec codec, Multihash.Type type, byte[] hash) {
        super(type, hash);
        this.version = version;
        this.codec = codec;
    }

    public static Cid build(long version, Codec codec, Multihash h) {
        return new Cid(version, codec, h.getType(), h.getHash());
    }

    private byte[] toBytesV0() {
        return super.toBytes();
    }

    private byte[] toBytesV1() {
        try {
            ByteArrayOutputStream res = new ByteArrayOutputStream();
            Cid.putUvarint((OutputStream)res, (long)this.version);
            Cid.putUvarint((OutputStream)res, (long)this.codec.type);
            super.serialize((OutputStream)res);
            return res.toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public byte[] toBytes() {
        if (this.version == 0L) {
            return this.toBytesV0();
        }
        if (this.version == 1L) {
            return this.toBytesV1();
        }
        throw new IllegalStateException("Unknown cid version: " + this.version);
    }

    public String toString() {
        if (this.version == 0L) {
            return super.toString();
        }
        if (this.version == 1L) {
            return Multibase.encode((Multibase.Base)Multibase.Base.Base58BTC, (byte[])this.toBytesV1());
        }
        throw new IllegalStateException("Unknown Cid version: " + this.version);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Multihash)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (o instanceof Cid) {
            Cid cid = (Cid)((Object)o);
            if (this.version != cid.version) {
                return false;
            }
            return this.codec == cid.codec;
        }
        return this.version == 0L && super.equals(o);
    }

    public int hashCode() {
        int result = super.hashCode();
        if (this.version == 0L) {
            return result;
        }
        result = 31 * result + (int)(this.version ^ this.version >>> 32);
        result = 31 * result + (this.codec != null ? this.codec.hashCode() : 0);
        return result;
    }

    public static Cid buildV0(Multihash h) {
        return Cid.build(0L, Codec.DagProtobuf, h);
    }

    public static Cid buildCidV1(Codec c, Multihash.Type type, byte[] hash) {
        return new Cid(1L, c, type, hash);
    }

    public static Cid decode(String v) {
        if (v.length() < 2) {
            throw new IllegalStateException("Cid too short!");
        }
        if (v.length() == 46 && v.startsWith("Qm")) {
            return Cid.buildV0(Multihash.fromBase58((String)v));
        }
        byte[] data = Multibase.decode((String)v);
        return Cid.cast(data);
    }

    public static Cid cast(byte[] data) {
        if (data.length == 34 && data[0] == 18 && data[1] == 32) {
            return Cid.buildV0(new Multihash(Multihash.Type.lookup((int)(data[0] & 0xFF)), Arrays.copyOfRange(data, 2, data.length)));
        }
        ByteArrayInputStream in = new ByteArrayInputStream(data);
        try {
            long version = Cid.readVarint((InputStream)in);
            if (version != 0L && version != 1L) {
                throw new CidEncodingException("Invalid Cid version number: " + version);
            }
            long codec = Cid.readVarint((InputStream)in);
            Multihash hash = Multihash.deserialize((InputStream)in);
            return new Cid(version, Codec.lookup(codec), hash.getType(), hash.getHash());
        }
        catch (Exception e) {
            throw new CidEncodingException("Invalid cid bytes: " + Cid.bytesToHex(data));
        }
    }

    private static String byteToHex(byte b) {
        return HEX[b & 0xFF];
    }

    private static String bytesToHex(byte[] data) {
        StringBuilder s = new StringBuilder();
        for (byte b : data) {
            s.append(Cid.byteToHex(b));
        }
        return s.toString();
    }

    static {
        for (int i = 0; i < 256; ++i) {
            Cid.HEX[i] = HEX_DIGITS[i >> 4 & 0xF] + HEX_DIGITS[i & 0xF];
        }
    }

    public static enum Codec {
        Raw(85L),
        DagProtobuf(112L),
        DagCbor(113L),
        EthereumBlock(144L),
        EthereumTx(145L),
        BitcoinBlock(176L),
        BitcoinTx(177L),
        ZcashBlock(192L),
        ZcashTx(193L);

        public long type;
        private static Map<Long, Codec> lookup;

        private Codec(long type) {
            this.type = type;
        }

        public static Codec lookup(long c) {
            if (!lookup.containsKey(c)) {
                throw new IllegalStateException("Unknown Codec type: " + c);
            }
            return lookup.get(c);
        }

        static {
            lookup = new TreeMap<Long, Codec>();
            for (Codec c : Codec.values()) {
                lookup.put(c.type, c);
            }
        }
    }

    public static final class CidEncodingException
    extends RuntimeException {
        public CidEncodingException(String message) {
            super(message);
        }
    }
}

