/*
 * Decompiled with CFR 0.152.
 */
package io.ipfs.api.cbor;

import io.ipfs.api.cbor.CborDecoder;
import io.ipfs.api.cbor.CborEncoder;
import io.ipfs.api.cbor.CborType;
import io.ipfs.cid.Cid;
import io.ipfs.multihash.Multihash;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.stream.Collectors;

public interface CborObject {
    public static final int LINK_TAG = 42;

    public void serialize(CborEncoder var1);

    default public byte[] toByteArray() {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        CborEncoder encoder = new CborEncoder(bout);
        this.serialize(encoder);
        return bout.toByteArray();
    }

    public static CborObject fromByteArray(byte[] cbor) {
        return CborObject.deserialize(new CborDecoder(new ByteArrayInputStream(cbor)));
    }

    public static CborObject deserialize(CborDecoder decoder) {
        try {
            CborType type = decoder.peekType();
            switch (type.getMajorType()) {
                case 3: {
                    return new CborString(decoder.readTextString());
                }
                case 2: {
                    return new CborByteArray(decoder.readByteString());
                }
                case 0: {
                    return new CborLong(decoder.readInt());
                }
                case 1: {
                    return new CborLong(decoder.readInt());
                }
                case 7: {
                    if (type.getAdditionalInfo() == 22) {
                        decoder.readNull();
                        return new CborNull();
                    }
                    if (type.getAdditionalInfo() == 21) {
                        decoder.readBoolean();
                        return new CborBoolean(true);
                    }
                    if (type.getAdditionalInfo() == 20) {
                        decoder.readBoolean();
                        return new CborBoolean(false);
                    }
                    throw new IllegalStateException("Unimplemented simple type! " + type.getAdditionalInfo());
                }
                case 5: {
                    long nValues = decoder.readMapLength();
                    TreeMap<CborObject, CborObject> result = new TreeMap<CborObject, CborObject>();
                    for (long i = 0L; i < nValues; ++i) {
                        CborObject key = CborObject.deserialize(decoder);
                        CborObject value = CborObject.deserialize(decoder);
                        result.put(key, value);
                    }
                    return new CborMap(result);
                }
                case 4: {
                    long nItems = decoder.readArrayLength();
                    ArrayList<CborObject> res = new ArrayList<CborObject>((int)nItems);
                    for (long i = 0L; i < nItems; ++i) {
                        res.add(CborObject.deserialize(decoder));
                    }
                    return new CborList(res);
                }
                case 6: {
                    long tag = decoder.readTag();
                    if (tag == 42L) {
                        CborObject value = CborObject.deserialize(decoder);
                        if (value instanceof CborString) {
                            return new CborMerkleLink((Multihash)Cid.decode((String)((CborString)value).value));
                        }
                        if (value instanceof CborByteArray) {
                            byte[] bytes = ((CborByteArray)value).value;
                            if (bytes[0] == 0) {
                                return new CborMerkleLink((Multihash)Cid.cast((byte[])Arrays.copyOfRange(bytes, 1, bytes.length)));
                            }
                            throw new IllegalStateException("Unknown Multibase decoding Merkle link: " + bytes[0]);
                        }
                        throw new IllegalStateException("Invalid type for merkle link: " + value);
                    }
                    throw new IllegalStateException("Unknown TAG in CBOR: " + type.getAdditionalInfo());
                }
            }
            throw new IllegalStateException("Unimplemented cbor type: " + type);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static final class CborNull
    implements CborObject,
    Comparable<CborNull> {
        @Override
        public int compareTo(CborNull cborNull) {
            return 0;
        }

        @Override
        public void serialize(CborEncoder encoder) {
            try {
                encoder.writeNull();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            return o != null && this.getClass() == o.getClass();
        }

        public int hashCode() {
            return 0;
        }

        public String toString() {
            return "CborNull{}";
        }
    }

    public static final class CborLong
    implements CborObject,
    Comparable<CborLong> {
        public final long value;

        public CborLong(long value) {
            this.value = value;
        }

        @Override
        public int compareTo(CborLong other) {
            return Long.compare(this.value, other.value);
        }

        @Override
        public void serialize(CborEncoder encoder) {
            try {
                encoder.writeInt(this.value);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CborLong cborLong = (CborLong)o;
            return this.value == cborLong.value;
        }

        public int hashCode() {
            return (int)(this.value ^ this.value >>> 32);
        }

        public String toString() {
            return "CborLong{" + this.value + '}';
        }
    }

    public static final class CborString
    implements CborObject,
    Comparable<CborString> {
        public final String value;

        public CborString(String value) {
            this.value = value;
        }

        @Override
        public int compareTo(CborString cborString) {
            int lenDiff = this.value.length() - cborString.value.length();
            if (lenDiff != 0) {
                return lenDiff;
            }
            return this.value.compareTo(cborString.value);
        }

        @Override
        public void serialize(CborEncoder encoder) {
            try {
                encoder.writeTextString(this.value);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CborString that = (CborString)o;
            return this.value.equals(that.value);
        }

        public int hashCode() {
            return this.value.hashCode();
        }

        public String toString() {
            return "CborString{\"" + this.value + "\"}";
        }
    }

    public static final class CborByteArray
    implements CborObject,
    Comparable<CborByteArray> {
        public final byte[] value;

        public CborByteArray(byte[] value) {
            this.value = value;
        }

        @Override
        public int compareTo(CborByteArray other) {
            return CborByteArray.compare(this.value, other.value);
        }

        public static int compare(byte[] a, byte[] b) {
            for (int i = 0; i < Math.min(a.length, b.length); ++i) {
                if (a[i] == b[i]) continue;
                return a[i] & 255 - b[i] & 0xFF;
            }
            return 0;
        }

        @Override
        public void serialize(CborEncoder encoder) {
            try {
                encoder.writeByteString(this.value);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CborByteArray that = (CborByteArray)o;
            return Arrays.equals(this.value, that.value);
        }

        public int hashCode() {
            return Arrays.hashCode(this.value);
        }
    }

    public static final class CborBoolean
    implements CborObject {
        public final boolean value;

        public CborBoolean(boolean value) {
            this.value = value;
        }

        @Override
        public void serialize(CborEncoder encoder) {
            try {
                encoder.writeBoolean(this.value);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CborBoolean that = (CborBoolean)o;
            return this.value == that.value;
        }

        public int hashCode() {
            return this.value ? 1 : 0;
        }

        public String toString() {
            return "CborBoolean{" + this.value + '}';
        }
    }

    public static final class CborList
    implements CborObject {
        public final List<CborObject> value;

        public CborList(List<CborObject> value) {
            this.value = value;
        }

        @Override
        public void serialize(CborEncoder encoder) {
            try {
                encoder.writeArrayStart(this.value.size());
                for (CborObject object : this.value) {
                    object.serialize(encoder);
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CborList cborList = (CborList)o;
            return this.value != null ? this.value.equals(cborList.value) : cborList.value == null;
        }

        public int hashCode() {
            return this.value != null ? this.value.hashCode() : 0;
        }
    }

    public static final class CborMerkleLink
    implements CborObject {
        public final Multihash target;

        public CborMerkleLink(Multihash target) {
            this.target = target;
        }

        @Override
        public void serialize(CborEncoder encoder) {
            try {
                encoder.writeTag(42L);
                byte[] cid = this.target.toBytes();
                byte[] withMultibaseHeader = new byte[cid.length + 1];
                System.arraycopy(cid, 0, withMultibaseHeader, 1, cid.length);
                encoder.writeByteString(withMultibaseHeader);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CborMerkleLink that = (CborMerkleLink)o;
            return this.target != null ? this.target.equals((Object)that.target) : that.target == null;
        }

        public int hashCode() {
            return this.target != null ? this.target.hashCode() : 0;
        }
    }

    public static final class CborMap
    implements CborObject {
        public final SortedMap<CborObject, CborObject> values;

        public CborMap(SortedMap<CborObject, CborObject> values) {
            this.values = values;
        }

        public static CborMap build(Map<String, CborObject> values) {
            SortedMap transformed = values.entrySet().stream().collect(Collectors.toMap(e -> new CborString((String)e.getKey()), e -> (CborObject)e.getValue(), (a, b) -> a, TreeMap::new));
            return new CborMap(transformed);
        }

        @Override
        public void serialize(CborEncoder encoder) {
            try {
                encoder.writeMapStart(this.values.size());
                for (Map.Entry<CborObject, CborObject> entry : this.values.entrySet()) {
                    entry.getKey().serialize(encoder);
                    entry.getValue().serialize(encoder);
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CborMap cborMap = (CborMap)o;
            return this.values != null ? this.values.equals(cborMap.values) : cborMap.values == null;
        }

        public int hashCode() {
            return this.values != null ? this.values.hashCode() : 0;
        }
    }
}

