/*
 * Decompiled with CFR 0.152.
 */
package net.io_0.maja.mapping.jackson;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.BeanPropertyWriter;
import com.fasterxml.jackson.databind.ser.BeanSerializerModifier;
import java.util.List;
import net.io_0.maja.PropertyBuildingUtils;
import net.io_0.maja.PropertyBundle;

public class PropertyBundleBeanSerializerModifier
extends BeanSerializerModifier {
    public List<BeanPropertyWriter> changeProperties(SerializationConfig config, BeanDescription beanDesc, List<BeanPropertyWriter> beanProperties) {
        if (PropertyBundleBeanSerializerModifier.extendsPropertyBundle(beanDesc.getBeanClass())) {
            for (int i = 0; i < beanProperties.size(); ++i) {
                BeanPropertyWriter beanPropertyWriter = beanProperties.get(i);
                PropertyBundleBeanPropertyWriter writer = new PropertyBundleBeanPropertyWriter(beanPropertyWriter, beanPropertyWriter.getName());
                beanProperties.set(i, writer);
            }
        }
        return super.changeProperties(config, beanDesc, beanProperties);
    }

    private static boolean extendsPropertyBundle(Class<?> type) {
        return PropertyBundle.class.isAssignableFrom(type);
    }

    private static class PropertyBundleBeanPropertyWriter
    extends BeanPropertyWriter {
        private PropertyBundleBeanPropertyWriter(BeanPropertyWriter base, String newSimpleName) {
            super(base, base.getFullName().withSimpleName(newSimpleName));
        }

        public void serializeAsField(Object bean, JsonGenerator gen, SerializerProvider prov) throws Exception {
            if (PropertyBundleBeanSerializerModifier.extendsPropertyBundle(bean.getClass())) {
                Object value;
                PropertyBundle model = (PropertyBundle)bean;
                if (!model.isPropertySet(this.getName())) {
                    if (!PropertyBuildingUtils.annotatedNameToJavaName(model, this.getName()).map(model::isPropertySet).orElse(false).booleanValue()) {
                        return;
                    }
                }
                Object object = value = this._accessorMethod == null ? this._field.get(bean) : this._accessorMethod.invoke(bean, (Object[])null);
                if (value == null) {
                    gen.writeNullField(this.getName());
                    return;
                }
            }
            super.serializeAsField(bean, gen, prov);
        }
    }
}

