/*
 * Decompiled with CFR 0.152.
 */
package net.io_0.maja;

import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import java.util.function.Supplier;
import net.io_0.maja.Property;
import net.io_0.maja.PropertyBuildingUtils;

public abstract class PropertyBundle {
    private final Set<String> setProperties = new HashSet<String>();

    public void markPropertySet(String name) {
        this.setProperties.add(name);
    }

    public void unmarkPropertySet(String name) {
        this.setProperties.remove(name);
    }

    public boolean isPropertySet(String name) {
        return this.setProperties.contains(name);
    }

    public <T> Property<T> getProperty(String name) {
        return (Property)PropertyBuildingUtils.annotatedNameToJavaName(this, name).flatMap(javaName -> PropertyBuildingUtils.extractProperty(this, javaName, this.constructWith(name, (String)javaName))).or(() -> PropertyBuildingUtils.extractProperty(this, name, this.constructWith(name, name))).orElseThrow(() -> new IllegalArgumentException(String.format("Property with name '%s' not found on %s", name, this.getClass().getSimpleName())));
    }

    private <T> Function<PropertyDescriptor, Property<T>> constructWith(String propertyName, String javaName) {
        return propertyDescriptor -> {
            final Supplier<String> name = () -> propertyName;
            final Supplier<Object> value = () -> {
                try {
                    return propertyDescriptor.getReadMethod().invoke((Object)this, new Object[0]);
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    throw new IllegalArgumentException(String.format("Couldn't access property with name '%s' on %s", javaName, this.getClass().getSimpleName()), e);
                }
            };
            final BooleanSupplier assigned = () -> this.isPropertySet(javaName);
            return new Property<T>(){

                @Override
                public String getName() {
                    return (String)name.get();
                }

                @Override
                public T getValue() {
                    Object v = value.get();
                    Objects.requireNonNull(v);
                    return v;
                }

                @Override
                public boolean isAssigned() {
                    return assigned.getAsBoolean();
                }

                @Override
                public boolean isNull() {
                    Object v = value.get();
                    return Objects.isNull(v);
                }
            };
        };
    }
}

