/*
 * Decompiled with CFR 0.152.
 */
package net.io_0.maja;

import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.util.Optional;
import java.util.function.Function;
import net.io_0.maja.Property;
import net.io_0.maja.StringUtils;
import net.io_0.maja.WithUnconventionalName;

public interface PropertyBuildingUtils {
    public static <T> Optional<Property<T>> extractProperty(Object model, String propertyName, Function<PropertyDescriptor, Property<T>> constructor) {
        try {
            for (PropertyDescriptor pd : Introspector.getBeanInfo(model.getClass()).getPropertyDescriptors()) {
                if (pd.getReadMethod() == null || !StringUtils.ignoreFirstCharCaseEquals(propertyName, pd.getName())) continue;
                return Optional.of(constructor.apply(pd));
            }
        }
        catch (IntrospectionException e) {
            throw new IllegalArgumentException(String.format("Couldn't access property with name '%s' on %s", propertyName, model.getClass().getSimpleName()), e);
        }
        return Optional.empty();
    }

    public static Optional<String> annotatedNameToJavaName(Object model, String annotatedName) {
        for (Field field : model.getClass().getDeclaredFields()) {
            if (!field.isAnnotationPresent(WithUnconventionalName.class) || !annotatedName.equals(field.getAnnotation(WithUnconventionalName.class).value())) continue;
            return Optional.of(field.getName());
        }
        return Optional.empty();
    }
}

