/*
 * Decompiled with CFR 0.152.
 */
package net.io_0.maja.validation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.io_0.maja.PojoProperty;
import net.io_0.maja.Property;
import net.io_0.maja.PropertyIssue;
import net.io_0.maja.PropertyIssues;
import net.io_0.maja.validation.PropertyPredicate;
import net.io_0.maja.validation.PropertyPredicates;
import net.io_0.maja.validation.PropertyValidator;
import net.io_0.maja.validation.Validation;
import net.io_0.maja.validation.Validator;

public interface PropertyValidators {
    public static final String PASSWORD_PATTERN = "^(?=.*?\\p{Lu})(?=.*?\\p{Ll})(?=.*?\\d)(?=.*?[`~!@#$%^&*()\\-_=+\\\\|\\[{\\]};:'\",<.>/?]).*$";
    public static final PropertyValidator<String> passwordFormat = PropertyValidator.of(PropertyPredicates.unassignedOrNullOr(PropertyPredicates.regexMatch("^(?=.*?\\p{Lu})(?=.*?\\p{Ll})(?=.*?\\d)(?=.*?[`~!@#$%^&*()\\-_=+\\\\|\\[{\\]};:'\",<.>/?]).*$")), PropertyIssue.Issue.of("Password Format Violation", "Must at least contain 1 number, 1 lower case letter, 1 upper case letter and 1 special character"));
    public static final String BINARY_PATTERN = "^([A-Fa-f0-9]{2})+$";
    public static final PropertyValidator<String> binaryFormat = PropertyValidator.of(PropertyPredicates.unassignedOrNullOr(PropertyPredicates.regexMatch("^([A-Fa-f0-9]{2})+$")), PropertyIssue.Issue.of("Binary Format Violation", "Must be a sequence of octets"));
    public static final String BASE64_PATTERN = "^([A-Za-z0-9+/]{4})*([A-Za-z0-9+/]{3}=|[A-Za-z0-9+/]{2}==)?$";
    public static final PropertyValidator<String> byteFormat = PropertyValidator.of(PropertyPredicates.unassignedOrNullOr(PropertyPredicates.regexMatch("^([A-Za-z0-9+/]{4})*([A-Za-z0-9+/]{3}=|[A-Za-z0-9+/]{2}==)?$")), PropertyIssue.Issue.of("Byte Format Violation", "Must be base64 format"));
    public static final PropertyValidator<String> emailFormat = PropertyValidator.of(PropertyPredicates.unassignedOrNullOr(PropertyPredicates.email), PropertyIssue.Issue.of("Email Format Violation", "Must fit email format"));
    public static final PropertyValidator<String> hostnameFormat = PropertyValidator.of(PropertyPredicates.unassignedOrNullOr(PropertyPredicates.hostname), PropertyIssue.Issue.of("Hostname Format Violation", "Must fit hostname format"));
    public static final PropertyValidator<String> ipV4Format = PropertyValidator.of(PropertyPredicates.unassignedOrNullOr(PropertyPredicates.inet4Address), PropertyIssue.Issue.of("IP V4 Format Violation", "Must fit IP v4 format"));
    public static final PropertyValidator<String> ipV6Format = PropertyValidator.of(PropertyPredicates.unassignedOrNullOr(PropertyPredicates.inet6Address), PropertyIssue.Issue.of("IP V6 Format Violation", "Must fit IP v6 format"));
    public static final PropertyValidator<?> notNull = PropertyValidator.of(PropertyPredicates.unassignedOrNotNull, PropertyIssue.Issue.of("Not Null Violation", "Can't be literally null"));
    public static final PropertyValidator<?> required = PropertyValidator.of(PropertyPredicates.assigned, PropertyIssue.Issue.of("Required Violation", "Is required but missing"));

    public static PropertyValidator<String> pattern(String parameter) {
        return PropertyValidator.of(PropertyPredicates.unassignedOrNullOr(PropertyPredicates.regexMatch(parameter)), PropertyIssue.Issue.of(String.format("Pattern Violation, '%s'", parameter), String.format("Must match '%s' pattern", parameter)));
    }

    public static PropertyValidator<String> maxLength(Integer parameter) {
        return PropertyValidator.of(PropertyPredicates.unassignedOrNullOr(PropertyPredicates.lengthLte(parameter)), PropertyIssue.Issue.of(String.format("Max Length Violation, %s", parameter), String.format("Must be shorter than %s characters", parameter)));
    }

    public static PropertyValidator<String> minLength(Integer parameter) {
        return PropertyValidator.of(PropertyPredicates.unassignedOrNullOr(PropertyPredicates.lengthGte(parameter)), PropertyIssue.Issue.of(String.format("Min Length Violation, %s", parameter), String.format("Must be longer than %s characters", parameter)));
    }

    public static PropertyValidator<Number> exclusiveMaximum(Number parameter) {
        return PropertyValidator.of(PropertyPredicates.unassignedOrNullOr(PropertyPredicates.gt(parameter)), PropertyIssue.Issue.of(String.format("Exclusive Maximum Violation, %s", parameter), String.format("Must be lessen than %s", parameter)));
    }

    public static PropertyValidator<Number> exclusiveMinimum(Number parameter) {
        return PropertyValidator.of(PropertyPredicates.unassignedOrNullOr(PropertyPredicates.lt(parameter)), PropertyIssue.Issue.of(String.format("Exclusive Minimum Violation, %s", parameter), String.format("Must be greater than %s", parameter)));
    }

    public static PropertyValidator<Number> maximum(Number parameter) {
        return PropertyValidator.of(PropertyPredicates.unassignedOrNullOr(PropertyPredicates.gte(parameter)), PropertyIssue.Issue.of(String.format("Maximum Violation, %s", parameter), String.format("Must be %s or lesser", parameter)));
    }

    public static PropertyValidator<Number> minimum(Number parameter) {
        return PropertyValidator.of(PropertyPredicates.unassignedOrNullOr(PropertyPredicates.lte(parameter)), PropertyIssue.Issue.of(String.format("Minimum Violation, %s", parameter), String.format("Must be %s or greater", parameter)));
    }

    public static PropertyValidator<Number> multipleOf(Number parameter) {
        return PropertyValidator.of(PropertyPredicates.unassignedOrNullOr(PropertyPredicates.multipleOf(parameter)), PropertyIssue.Issue.of(String.format("Multiple Of Violation, %s", parameter), String.format("Must be a multiple of %s", parameter)));
    }

    public static PropertyValidator<?> maxItems(Integer parameter) {
        return PropertyValidators.mapOrCollection(PropertyPredicates.sizeLte(parameter), PropertyIssue.Issue.of(String.format("Max Items Violation, %s", parameter), String.format("Must contain %s items or less", parameter)));
    }

    public static PropertyValidator<?> minItems(Integer parameter) {
        return PropertyValidators.mapOrCollection(PropertyPredicates.sizeGte(parameter), PropertyIssue.Issue.of(String.format("Min Items Violation, %s", parameter), String.format("Must contain %s items or more", parameter)));
    }

    public static PropertyValidator<?> mapOrCollection(PropertyPredicate<?> predicate, PropertyIssue.Issue issue) {
        return property -> {
            if (PropertyPredicates.unassignedOrNull.test((Property<?>)property)) {
                return Validation.valid(property);
            }
            Property propertyToTest = property.getValue() instanceof Map ? new PojoProperty(property.getName(), ((Map)property.getValue()).entrySet()) : property;
            return predicate.test(propertyToTest) ? Validation.valid(property) : Validation.invalid(PropertyIssue.of(property.getName(), issue));
        };
    }

    public static <T> PropertyValidator<?> each(PropertyValidator<? extends T> ... validators) {
        return property -> {
            Stream<PojoProperty> propertyStream;
            Object values;
            if (PropertyPredicates.unassignedOrNull.test((Property<?>)property)) {
                return Validation.valid(property);
            }
            if (property.getValue() instanceof Map) {
                values = (Map)property.getValue();
                propertyStream = values.entrySet().stream().map(entry -> new PojoProperty(String.format("%s.%s", property.getName(), entry.getKey()), entry.getValue()));
            } else {
                values = new ArrayList((Collection)property.getValue());
                propertyStream = IntStream.range(0, values.size()).mapToObj(arg_0 -> PropertyValidators.lambda$each$2(property, (List)values, arg_0));
            }
            PropertyValidator validator = PropertyValidator.andAll(validators);
            return propertyStream.map(validator::validate).filter(Validation::isInvalid).reduce(Validation::and).map(validation -> Validation.of(property, validation.getPropertyIssues())).orElse(Validation.valid(property));
        };
    }

    public static <T> PropertyValidator<T> valid(Validator<T> validator) {
        return property -> {
            if (PropertyPredicates.unassignedOrNull.test((Property<?>)property)) {
                return Validation.valid(property);
            }
            Validation validation = validator.validate(property.getValue());
            if (validation.isValid()) {
                return Validation.valid(property);
            }
            return Validation.invalid(PropertyIssues.of((PropertyIssue[])validation.getPropertyIssues().stream().map(propertyIssue -> PropertyIssue.of(String.format("%s.%s", property.getName(), propertyIssue.getPropertyName()), propertyIssue.getIssue())).toArray(PropertyIssue[]::new)));
        };
    }

    public static <T> Validator<T> lazy(Supplier<Validator<T>> validatorSupplier) {
        return t -> ((Validator)validatorSupplier.get()).validate(t);
    }

    private static /* synthetic */ PojoProperty lambda$each$2(Property property, List values, int i) {
        return new PojoProperty(String.format("%s.%d", property.getName(), i), values.get(i));
    }
}

