/*
 * Decompiled with CFR 0.152.
 */
package net.io_0.maja;

public class PropertyIssue {
    private final String propertyName;
    private final Issue issue;

    public static PropertyIssue of(String propertyName, Issue issue) {
        return new PropertyIssue(propertyName, issue);
    }

    public static PropertyIssue of(String propertyName, String code, String message) {
        return new PropertyIssue(propertyName, Issue.of(code, message));
    }

    public PropertyIssue withMessage(String message) {
        return new PropertyIssue(this.propertyName, this.issue.withMessage(message));
    }

    public PropertyIssue withPropertyNamePrefix(String prefix) {
        return new PropertyIssue(prefix + this.propertyName, this.issue);
    }

    private PropertyIssue(String propertyName, Issue issue) {
        this.propertyName = propertyName;
        this.issue = issue;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public Issue getIssue() {
        return this.issue;
    }

    public String toString() {
        return "PropertyIssue(propertyName=" + this.getPropertyName() + ", issue=" + this.getIssue() + ")";
    }

    public static class Issue {
        private final String code;
        private final String message;

        public static Issue of(String code, String message) {
            return new Issue(code, message);
        }

        public Issue withMessage(String message) {
            return Issue.of(this.code, message);
        }

        public String toString() {
            return String.format("Issue(code=%s, message=%s)", this.code, this.message);
        }

        private Issue(String code, String message) {
            this.code = code;
            this.message = message;
        }

        public String getCode() {
            return this.code;
        }

        public String getMessage() {
            return this.message;
        }
    }
}

