/*
 * Decompiled with CFR 0.152.
 */
package net.io_0.caja.sync;

import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;

public interface Cache<K, V> {
    public V get(K var1);

    public void put(K var1, V var2);

    public boolean containsKey(K var1);

    public List<K> keys();

    public void remove(K var1);

    public void clear();

    default public V getThrough(K key, Supplier<V> valueSupplier) {
        if (!this.containsKey(key)) {
            this.put(key, valueSupplier.get());
        }
        return this.get(key);
    }

    default public CompletableFuture<V> getThroughFuture(K key, Supplier<CompletableFuture<V>> valueSupplier) {
        return this.containsKey(key) ? CompletableFuture.completedFuture(this.get(key)) : valueSupplier.get().whenComplete((value, error) -> {
            if (Objects.isNull(error)) {
                this.put(key, value);
            }
        });
    }
}

