/*
 * Decompiled with CFR 0.152.
 */
package net.io_0.caja.redis;

import io.lettuce.core.api.async.RedisAsyncCommands;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.stream.Collectors;
import net.io_0.caja.async.Cache;
import net.io_0.caja.redis.KeyOrWildcard;

public class RedisAsyncWrapper {
    public static <K, V> Cache<K, V> wrap(final RedisAsyncCommands<KeyOrWildcard<K>, V> cache, final Integer ttlInSeconds) {
        return new Cache<K, V>(){

            @Override
            public CompletableFuture<V> get(K key) {
                Objects.requireNonNull(key);
                return cache.get(KeyOrWildcard.key(key)).toCompletableFuture();
            }

            @Override
            public CompletableFuture<Void> put(K key, V value) {
                Objects.requireNonNull(key);
                return cache.setex(KeyOrWildcard.key(key), (long)ttlInSeconds.intValue(), value).toCompletableFuture().thenApply(ignore -> null);
            }

            @Override
            public CompletableFuture<Boolean> containsKey(K key) {
                Objects.requireNonNull(key);
                return cache.exists((Object[])new KeyOrWildcard[]{KeyOrWildcard.key(key)}).toCompletableFuture().thenApply(keyCount -> keyCount > 0L);
            }

            @Override
            public CompletableFuture<List<K>> keys() {
                return this.fetchKeys().thenApply(containers -> containers.stream().map(KeyOrWildcard::getKey).collect(Collectors.toList()));
            }

            private CompletableFuture<List<KeyOrWildcard<K>>> fetchKeys() {
                return cache.keys(KeyOrWildcard.wildcard()).toCompletableFuture();
            }

            @Override
            public CompletableFuture<Void> remove(K key) {
                Objects.requireNonNull(key);
                return cache.del((Object[])new KeyOrWildcard[]{KeyOrWildcard.key(key)}).toCompletableFuture().thenApply(ignore -> null);
            }

            @Override
            public CompletableFuture<Void> clear() {
                return this.fetchKeys().thenCompose(keys -> CompletableFuture.allOf((CompletableFuture[])keys.stream().map(xva$0 -> cache.del((Object[])new KeyOrWildcard[]{xva$0})).map(CompletionStage::toCompletableFuture).toArray(CompletableFuture[]::new)));
            }
        };
    }

    private RedisAsyncWrapper() {
    }
}

