/*
 * Decompiled with CFR 0.152.
 */
package net.io_0.caja;

import io.lettuce.core.AbstractRedisClient;
import io.lettuce.core.ReadFrom;
import io.lettuce.core.RedisClient;
import io.lettuce.core.RedisURI;
import io.lettuce.core.api.StatefulConnection;
import io.lettuce.core.api.StatefulRedisConnection;
import io.lettuce.core.api.async.RedisAsyncCommands;
import io.lettuce.core.api.sync.RedisCommands;
import io.lettuce.core.masterreplica.MasterReplica;
import io.lettuce.core.masterreplica.StatefulRedisMasterReplicaConnection;
import java.time.Duration;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import net.io_0.caja.configuration.CacheConfig;
import net.io_0.caja.configuration.CacheManagerConfig;
import net.io_0.caja.configuration.LocalCacheConfig;
import net.io_0.caja.configuration.RemoteCacheConfig;
import net.io_0.caja.ehcache.EhcacheAsyncWrapper;
import net.io_0.caja.ehcache.EhcacheSyncWrapper;
import net.io_0.caja.redis.JsonObjectCodec;
import net.io_0.caja.redis.KeyOrWildcard;
import net.io_0.caja.redis.RedisAsyncWrapper;
import net.io_0.caja.redis.RedisSyncWrapper;
import net.io_0.caja.sync.Cache;
import net.io_0.caja.sync.LoggingStatisticsDecorator;
import org.ehcache.config.Builder;
import org.ehcache.config.builders.CacheConfigurationBuilder;
import org.ehcache.config.builders.CacheManagerBuilder;
import org.ehcache.config.builders.ExpiryPolicyBuilder;
import org.ehcache.config.builders.ResourcePoolsBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CacheManager {
    private static final Logger log = LoggerFactory.getLogger(CacheManager.class);
    private final CacheManagerConfig config;
    private final org.ehcache.CacheManager localManager;
    private Map<String, RedisClient> clients = new ConcurrentHashMap<String, RedisClient>();
    private Map<String, StatefulRedisConnection<?, ?>> connections = new ConcurrentHashMap();

    public CacheManager() {
        this(new LocalCacheConfig());
    }

    public CacheManager(CacheConfig defaultConfig) {
        this(new CacheManagerConfig().setDefaultCacheConfiguration(defaultConfig));
    }

    public CacheManager(CacheManagerConfig config) {
        this.config = config;
        this.localManager = CacheManagerBuilder.newCacheManagerBuilder().build(true);
    }

    public <K, V> Cache<K, V> getAsSync(String name, Class<K> keyType, Class<V> valueType, Class<?> ... valueSubTypes) {
        return this.getAsSync(name, Context.ofDefaultConfig(this.config.getDefaultCacheConfiguration()), keyType, valueType, valueSubTypes);
    }

    public <K, V> net.io_0.caja.async.Cache<K, V> getAsAsync(String name, Class<K> keyType, Class<V> valueType, Class<?> ... valueSubTypes) {
        return this.getAsAsync(name, Context.ofDefaultConfig(this.config.getDefaultCacheConfiguration()), keyType, valueType, valueSubTypes);
    }

    public <K, V> Cache<K, V> getAsSync(String name, Context context, Class<K> keyType, Class<V> valueType, Class<?> ... valueSubTypes) {
        Cache<K, V> cache;
        CacheConfig cfg = this.config.getCacheConfigurations().getOrDefault(name, context.defaultConfig);
        Cache<K, V> cache2 = cache = cfg instanceof LocalCacheConfig ? EhcacheSyncWrapper.wrap(this.getLocalCache(name, keyType, valueType, (LocalCacheConfig)cfg)) : RedisSyncWrapper.wrap(this.getSyncRemoteCache(name, (RemoteCacheConfig)cfg, keyType, valueType, valueSubTypes), cfg.getTtlInSeconds());
        if (!CacheConfig.LogLevel.OFF.equals((Object)cfg.getLogStatistics())) {
            cache = new LoggingStatisticsDecorator<K, V>(name, cfg.getLogStatistics(), cache);
        }
        return cache;
    }

    public <K, V> net.io_0.caja.async.Cache<K, V> getAsAsync(String name, Context context, Class<K> keyType, Class<V> valueType, Class<?> ... valueSubTypes) {
        net.io_0.caja.async.Cache<K, V> cache;
        CacheConfig cfg = this.config.getCacheConfigurations().getOrDefault(name, context.defaultConfig);
        net.io_0.caja.async.Cache<K, V> cache2 = cache = cfg instanceof LocalCacheConfig ? EhcacheAsyncWrapper.wrap(this.getLocalCache(name, keyType, valueType, (LocalCacheConfig)cfg)) : RedisAsyncWrapper.wrap(this.getAsyncRemoteCache(name, (RemoteCacheConfig)cfg, keyType, valueType, valueSubTypes), cfg.getTtlInSeconds());
        if (!CacheConfig.LogLevel.OFF.equals((Object)cfg.getLogStatistics())) {
            cache = new net.io_0.caja.async.LoggingStatisticsDecorator<K, V>(name, cfg.getLogStatistics(), cache);
        }
        return cache;
    }

    @Deprecated(forRemoval=true)
    public <K, V> Cache<K, V> getAsSync(String name, Class<K> keyType, Class<V> valueType, CacheConfig defaultConfig) {
        return this.getAsSync(name, Context.ofDefaultConfig(defaultConfig), keyType, valueType, new Class[0]);
    }

    @Deprecated(forRemoval=true)
    public <K, V> net.io_0.caja.async.Cache<K, V> getAsAsync(String name, Class<K> keyType, Class<V> valueType, CacheConfig defaultConfig) {
        return this.getAsAsync(name, Context.ofDefaultConfig(defaultConfig), keyType, valueType, new Class[0]);
    }

    private <K, V> org.ehcache.Cache<K, V> getLocalCache(String name, Class<K> keyType, Class<V> valueType, LocalCacheConfig config) {
        org.ehcache.Cache localCache = this.localManager.getCache(name, keyType, valueType);
        if (Objects.isNull(localCache)) {
            localCache = this.localManager.createCache(name, CacheConfigurationBuilder.newCacheConfigurationBuilder(keyType, valueType, (Builder)ResourcePoolsBuilder.heap((long)config.getHeap().intValue())).withExpiry(ExpiryPolicyBuilder.timeToLiveExpiration((Duration)Duration.ofSeconds(config.getTtlInSeconds().intValue()))).build());
            log.debug("{}: created with {}", (Object)name, (Object)config);
        }
        return localCache;
    }

    private <K, V> RedisCommands<KeyOrWildcard<K>, V> getSyncRemoteCache(String name, RemoteCacheConfig config, Class<K> keyType, Class<V> valueType, Class<?> ... valueSubTypes) {
        return this.getRemoteCacheConnection(name, config, keyType, valueType, valueSubTypes).sync();
    }

    private <K, V> RedisAsyncCommands<KeyOrWildcard<K>, V> getAsyncRemoteCache(String name, RemoteCacheConfig config, Class<K> keyType, Class<V> valueType, Class<?> ... valueSubTypes) {
        return this.getRemoteCacheConnection(name, config, keyType, valueType, valueSubTypes).async();
    }

    private <K, V> StatefulRedisConnection<KeyOrWildcard<K>, V> getRemoteCacheConnection(String name, RemoteCacheConfig config, Class<K> keyType, Class<V> valueType, Class<?> ... valueSubTypes) {
        StatefulRedisMasterReplicaConnection connection;
        String host = config.getHost();
        RedisClient client = this.clients.get(host);
        if (Objects.isNull(client)) {
            client = RedisClient.create((String)host);
            this.clients.put(host, client);
            log.debug("{}: created client with {}", (Object)name, (Object)config);
        }
        if (Objects.isNull(connection = (StatefulRedisMasterReplicaConnection)this.connections.get(String.format("%s|%s", name, host)))) {
            connection = MasterReplica.connect((RedisClient)client, new JsonObjectCodec(name, keyType, valueType, valueSubTypes), (RedisURI)RedisURI.create((String)host));
            connection.setReadFrom(this.toLettuceReadFrom(config.getReadFrom()));
            this.connections.put(String.format("%s|%s", name, host), (StatefulRedisConnection<?, ?>)connection);
            log.debug("{}: created connection with {}", (Object)name, (Object)config);
        }
        return connection;
    }

    private ReadFrom toLettuceReadFrom(RemoteCacheConfig.ReadFrom readFrom) {
        switch (readFrom) {
            case UPSTREAM: {
                return ReadFrom.UPSTREAM;
            }
            case UPSTREAM_PREFERRED: {
                return ReadFrom.UPSTREAM_PREFERRED;
            }
            case REPLICA: {
                return ReadFrom.REPLICA;
            }
            case REPLICA_PREFERRED: {
                return ReadFrom.REPLICA_PREFERRED;
            }
        }
        log.warn("{} is not supported. Read from UPSTREAM is used as fallback.", (Object)readFrom);
        return ReadFrom.UPSTREAM;
    }

    public void close() {
        this.localManager.close();
        this.connections.values().forEach(StatefulConnection::close);
        this.clients.values().forEach(AbstractRedisClient::shutdown);
    }

    public static class Context {
        private CacheConfig defaultConfig;

        public static Context of() {
            return Context.builder().build();
        }

        public static Context ofDefaultConfig(CacheConfig dC) {
            return Context.builder().defaultConfig(dC).build();
        }

        private static CacheConfig $default$defaultConfig() {
            return new LocalCacheConfig();
        }

        Context(CacheConfig defaultConfig) {
            this.defaultConfig = defaultConfig;
        }

        public static ContextBuilder builder() {
            return new ContextBuilder();
        }

        public static class ContextBuilder {
            private boolean defaultConfig$set;
            private CacheConfig defaultConfig$value;

            ContextBuilder() {
            }

            public ContextBuilder defaultConfig(CacheConfig defaultConfig) {
                this.defaultConfig$value = defaultConfig;
                this.defaultConfig$set = true;
                return this;
            }

            public Context build() {
                CacheConfig defaultConfig$value = this.defaultConfig$value;
                if (!this.defaultConfig$set) {
                    defaultConfig$value = Context.$default$defaultConfig();
                }
                return new Context(defaultConfig$value);
            }

            public String toString() {
                return "CacheManager.Context.ContextBuilder(defaultConfig$value=" + this.defaultConfig$value + ")";
            }
        }
    }

    static class ClientAndConnection<K, V> {
        final RedisClient client;
        final StatefulRedisConnection<K, V> connection;

        public ClientAndConnection(RedisClient client, StatefulRedisConnection<K, V> connection) {
            this.client = client;
            this.connection = connection;
        }
    }
}

