/*
 * Decompiled with CFR 0.152.
 */
package net.io_0.caja.sync;

import java.util.List;
import java.util.Objects;
import net.io_0.caja.LoggingUtils;
import net.io_0.caja.configuration.CacheConfig;
import net.io_0.caja.sync.Cache;
import net.io_0.caja.sync.CacheDecorator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingStatisticsDecorator<K, V>
extends CacheDecorator<K, V> {
    private static final Logger log = LoggerFactory.getLogger(LoggingStatisticsDecorator.class);
    private final String name;
    private final CacheConfig.LogLevel logLevel;

    public LoggingStatisticsDecorator(String name, CacheConfig.LogLevel logLevel, Cache<K, V> cache) {
        super(cache);
        this.name = name;
        this.logLevel = logLevel;
    }

    @Override
    public V get(K key) {
        Object value = this.cache.get(key);
        this.log("{}: {} value for '{}'", this.name, Objects.nonNull(value) ? "got" : "missed", key);
        return value;
    }

    @Override
    public void put(K key, V value) {
        this.log("{}: put value for '{}'", this.name, key);
        this.cache.put(key, value);
    }

    @Override
    public boolean containsKey(K key) {
        boolean isKeyPresent = this.cache.containsKey(key);
        this.log("{}: {} key '{}'", this.name, isKeyPresent ? "contained" : "missed", key);
        return isKeyPresent;
    }

    @Override
    public List<K> keys() {
        List keys = this.cache.keys();
        this.log("{}: fetched {} active keys", this.name, keys.size());
        return keys;
    }

    @Override
    public void remove(K key) {
        this.log("{}: removed value for '{}'", this.name, key);
        this.cache.remove(key);
    }

    @Override
    public void clear() {
        this.log("{}: cleared", this.name);
        this.cache.clear();
    }

    private void log(String format, Object ... arguments) {
        LoggingUtils.logThrough(log, this.logLevel, format, arguments);
    }
}

