/*
 * Decompiled with CFR 0.152.
 */
package net.io_0.caja.redis;

import io.lettuce.core.codec.RedisCodec;
import io.lettuce.core.codec.StringCodec;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.UUID;
import java.util.function.Predicate;
import net.io_0.caja.redis.KeyOrWildcard;
import net.io_0.maja.mapping.Mapper;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonObjectCodec<K, C extends KeyOrWildcard<K>, V>
implements RedisCodec<C, V> {
    private static final Logger log = LoggerFactory.getLogger(JsonObjectCodec.class);
    private final String cacheName;
    private final Class<K> keyType;
    private final Class<V> valueType;
    private final Class<?>[] subTypes;
    private static final String SEPARATOR = "/";
    private static final Predicate<Class<?>> isSimpleKeyType = JsonObjectCodec.isAnyOf(String.class, UUID.class, Integer.class, Long.class);

    public JsonObjectCodec(String cacheName, Class<K> keyType, Class<V> valueType, Class<?> ... subTypes) {
        this.cacheName = cacheName;
        this.keyType = keyType;
        this.valueType = valueType;
        this.subTypes = subTypes;
    }

    public C decodeKey(ByteBuffer bytes) {
        if (isSimpleKeyType.test(this.keyType)) {
            return (C)KeyOrWildcard.key(JsonObjectCodec.decodeSimpleKey(StringUtils.removeStart((String)StringCodec.UTF8.decodeValue(bytes), (String)(this.cacheName + SEPARATOR)), this.keyType));
        }
        return (C)KeyOrWildcard.key(((NameSpaceAndKey)Mapper.fromJson((String)StringCodec.UTF8.decodeValue((ByteBuffer)bytes), NameSpaceAndKey.class, (Class[])new Class[]{this.keyType})).key);
    }

    public V decodeValue(ByteBuffer bytes) {
        return (V)JsonObjectCodec.decode(bytes, this.valueType, this.subTypes);
    }

    public ByteBuffer encodeKey(KeyOrWildcard keyOrWildcard) {
        if (keyOrWildcard.isWildcard()) {
            if (isSimpleKeyType.test(this.keyType)) {
                return StringCodec.UTF8.encodeValue(this.cacheName + "/*");
            }
            return StringCodec.UTF8.encodeValue("{\"ns\":\"" + this.cacheName + "\",*");
        }
        if (isSimpleKeyType.test(this.keyType)) {
            return StringCodec.UTF8.encodeValue(this.cacheName + SEPARATOR + keyOrWildcard.getKey());
        }
        return JsonObjectCodec.encode(new NameSpaceAndKey(this.cacheName, keyOrWildcard.getKey()));
    }

    public ByteBuffer encodeValue(V value) {
        return JsonObjectCodec.encode(value);
    }

    private static Object decode(ByteBuffer bytes, Class<?> type, Class<?> ... subTypes) {
        return Mapper.fromJson((String)StringCodec.UTF8.decodeValue(bytes), type, (Class[])subTypes);
    }

    private static ByteBuffer encode(Object value) {
        return StringCodec.UTF8.encodeValue(Mapper.toJson((Object)value));
    }

    private static Object decodeSimpleKey(String key, Class<?> type) {
        if (type.equals(UUID.class)) {
            return UUID.fromString(key);
        }
        if (type.equals(Integer.class)) {
            return Integer.valueOf(key);
        }
        if (type.equals(Long.class)) {
            return Long.valueOf(key);
        }
        return key;
    }

    private static Predicate<Class<?>> isAnyOf(Class<?> ... types) {
        return type -> Arrays.asList(types).contains(type);
    }

    private static class NameSpaceAndKey<K> {
        private String ns;
        private K key;

        public NameSpaceAndKey(String ns, K key) {
            this.ns = ns;
            this.key = key;
        }

        public NameSpaceAndKey() {
        }

        public String getNs() {
            return this.ns;
        }

        public K getKey() {
            return this.key;
        }

        public void setNs(String ns) {
            this.ns = ns;
        }

        public void setKey(K key) {
            this.key = key;
        }
    }
}

