/*
 * Decompiled with CFR 0.152.
 */
package net.io_0.caja.ehcache;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import net.io_0.caja.async.Cache;
import org.ehcache.Cache;

public class EhcacheAsyncWrapper {
    public static <K, V> Cache<K, V> wrap(final org.ehcache.Cache<K, V> cache) {
        return new Cache<K, V>(){

            @Override
            public CompletableFuture<V> get(K key) {
                return CompletableFuture.supplyAsync(() -> cache.get(key));
            }

            @Override
            public CompletableFuture<Void> put(K key, V value) {
                return CompletableFuture.runAsync(() -> cache.put(key, value));
            }

            @Override
            public CompletableFuture<Boolean> containsKey(K key) {
                return CompletableFuture.supplyAsync(() -> cache.containsKey(key));
            }

            @Override
            public CompletableFuture<List<K>> keys() {
                return CompletableFuture.supplyAsync(() -> StreamSupport.stream(cache.spliterator(), false).map(Cache.Entry::getKey).collect(Collectors.toList()));
            }

            @Override
            public CompletableFuture<Void> remove(K key) {
                return CompletableFuture.runAsync(() -> cache.remove(key));
            }

            @Override
            public CompletableFuture<Void> clear() {
                return CompletableFuture.runAsync(() -> ((org.ehcache.Cache)cache).clear());
            }
        };
    }

    private EhcacheAsyncWrapper() {
    }
}

