/*
 * Decompiled with CFR 0.152.
 */
package com.github.invictum.allure;

import com.github.invictum.allure.Attach;
import io.qameta.allure.model.Label;
import io.qameta.allure.model.StatusDetails;
import io.qameta.allure.util.ResultsUtils;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URLConnection;
import java.nio.file.Files;
import java.time.Duration;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import net.thucydides.core.model.TestOutcome;
import net.thucydides.core.model.stacktrace.FailureCause;

public class Utils {
    public static Optional<StatusDetails> error(FailureCause cause) {
        if (cause != null) {
            Throwable exception = cause.toException();
            StringWriter writer = new StringWriter();
            cause.toException().printStackTrace(new PrintWriter(writer));
            String trace = writer.toString();
            return Optional.of(new StatusDetails().withMessage(exception.toString()).withTrace(trace));
        }
        return Optional.empty();
    }

    public static Optional<Attach> attachment(File file) {
        try {
            String mime = URLConnection.guessContentTypeFromName(file.getName());
            String extension = file.getName().split("\\.")[1];
            byte[] data = Files.readAllBytes(file.toPath());
            return Optional.of(new Attach(file.getName(), mime, extension, data));
        }
        catch (IOException e) {
            return Optional.empty();
        }
    }

    public static long finishTime(ZonedDateTime start, long duration) {
        return start.plus(Duration.ofMillis(duration)).toInstant().toEpochMilli();
    }

    public static List<Label> testLabels(TestOutcome testOutcome) {
        return new ArrayList<Label>(Arrays.asList(new Label().withName("suite").withValue(testOutcome.getUserStory().getPath()), new Label().withName("subSuite").withValue(testOutcome.getUserStory().getName()), new Label().withName("host").withValue(ResultsUtils.getHostName()), new Label().withName("thread").withValue(ResultsUtils.getThreadName()), new Label().withName("package").withValue(testOutcome.getUserStory().getPath()), new Label().withName("testClass").withValue(testOutcome.getUserStory().getName()), new Label().withName("testMethod").withValue(testOutcome.getDescription())));
    }
}

