/*
 * Decompiled with CFR 0.152.
 */
package com.github.invictum.allure;

import com.github.invictum.allure.StatusMapping;
import com.github.invictum.allure.Utils;
import io.qameta.allure.AllureLifecycle;
import io.qameta.allure.model.Stage;
import io.qameta.allure.model.StepResult;
import io.qameta.allure.model.TestResult;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.thucydides.core.model.DataTable;
import net.thucydides.core.model.Story;
import net.thucydides.core.model.TestOutcome;
import net.thucydides.core.model.TestStep;
import net.thucydides.core.steps.ExecutedStepDescription;
import net.thucydides.core.steps.StepFailure;
import net.thucydides.core.steps.StepListener;

public class AllureStepListener
implements StepListener {
    private ThreadLocal<AllureLifecycle> lifecycle = ThreadLocal.withInitial(AllureLifecycle::new);
    private ThreadLocal<String> uid = ThreadLocal.withInitial(() -> UUID.randomUUID().toString());

    public void testSuiteStarted(Class<?> storyClass) {
    }

    public void testSuiteStarted(Story story) {
    }

    public void testSuiteFinished() {
    }

    public void testStarted(String description) {
        this.lifecycle.get().scheduleTestCase(new TestResult().withName(description).withUuid(this.uid.get()));
        this.lifecycle.get().startTestCase(this.uid.get());
    }

    public void testStarted(String description, String id) {
        this.testStarted(description);
    }

    public void testFinished(TestOutcome testOutcome) {
        this.lifecycle.get().updateTestCase(this.uid.get(), test -> {
            test.withStatus(StatusMapping.discover(testOutcome.getResult()));
            test.withLabels(Utils.testLabels(testOutcome));
            this.proceedStepsTree(this.uid.get(), testOutcome.getTestSteps());
            test.withStop(Long.valueOf(Utils.finishTime(testOutcome.getStartTime(), testOutcome.getDuration())));
            Utils.error(testOutcome.getTestFailureCause()).ifPresent(arg_0 -> ((TestResult)test).withStatusDetails(arg_0));
            test.withStage(Stage.FINISHED);
        });
        this.lifecycle.get().writeTestCase(this.uid.get());
        this.uid.remove();
    }

    private void proceedStepsTree(String uid, List<TestStep> steps) {
        for (TestStep step : steps) {
            String stepUid = UUID.randomUUID().toString();
            StepResult stepResult = new StepResult().withName(step.getDescription());
            this.lifecycle.get().startStep(uid, stepUid, stepResult);
            this.lifecycle.get().updateStep(stepUid, update -> {
                update.withStatus(StatusMapping.discover(step.getResult()));
                long start = step.getStartTime().toInstant().toEpochMilli();
                update.withStart(Long.valueOf(start));
            });
            step.getScreenshots().forEach(source -> {
                Utils.attachment(source.getScreenshot()).ifPresent(attach -> this.lifecycle.get().addAttachment(attach.getName(), attach.getMime(), attach.getExtension(), attach.getBody()));
                if (source.getHtmlSource().isPresent()) {
                    Utils.attachment((File)source.getHtmlSource().get()).ifPresent(attach -> this.lifecycle.get().addAttachment(attach.getName(), attach.getMime(), attach.getExtension(), attach.getBody()));
                }
            });
            if (!step.getChildren().isEmpty()) {
                this.proceedStepsTree(stepUid, step.getChildren());
            }
            this.lifecycle.get().updateStep(stepUid, update -> {
                update.withStop(Long.valueOf(Utils.finishTime(step.getStartTime(), step.getDuration())));
                update.withStage(Stage.FINISHED);
            });
        }
    }

    public void testRetried() {
    }

    public void stepStarted(ExecutedStepDescription description) {
    }

    public void skippedStepStarted(ExecutedStepDescription executedStepDescription) {
    }

    public void stepFailed(StepFailure stepFailure) {
    }

    public void lastStepFailed(StepFailure stepFailure) {
    }

    public void stepIgnored() {
    }

    public void stepPending() {
    }

    public void stepPending(String s) {
    }

    public void stepFinished() {
    }

    public void testFailed(TestOutcome testOutcome, Throwable throwable) {
    }

    public void testIgnored() {
    }

    public void testSkipped() {
    }

    public void testPending() {
    }

    public void testIsManual() {
    }

    public void notifyScreenChange() {
    }

    public void useExamplesFrom(DataTable dataTable) {
    }

    public void addNewExamplesFrom(DataTable dataTable) {
    }

    public void exampleStarted(Map<String, String> map) {
    }

    public void exampleFinished() {
    }

    public void assumptionViolated(String s) {
    }

    public void testRunFinished() {
    }
}

