/*
 * Decompiled with CFR 0.152.
 */
package com.instacart.library.truetime.extensionrx;

import android.util.Log;
import com.instacart.library.truetime.SntpClient;
import com.instacart.library.truetime.TrueTime;
import java.util.Date;
import java.util.List;
import rx.Observable;
import rx.functions.Func1;
import rx.schedulers.Schedulers;

public class TrueTimeRx
extends TrueTime {
    private static final String TAG = TrueTimeRx.class.getSimpleName();
    private static final TrueTime INSTANCE = new TrueTimeRx();

    public static TrueTimeRx build() {
        return (TrueTimeRx)INSTANCE;
    }

    public TrueTimeRx withConnectionTimeout(int timeout) {
        super.withConnectionTimeout(timeout);
        return (TrueTimeRx)INSTANCE;
    }

    public Observable<Date> initialize(List<String> ntpHosts) {
        return Observable.from(ntpHosts).flatMap((Func1)new Func1<String, Observable<Date>>(){

            public Observable<Date> call(String ntpHost) {
                return Observable.just((Object)ntpHost).subscribeOn(Schedulers.io()).map((Func1)new Func1<String, Date>(){

                    public Date call(String host) {
                        SntpClient sntpClient = new SntpClient();
                        try {
                            Log.i((String)TAG, (String)("---- Querying host : " + host));
                            sntpClient.requestTime(host, TrueTimeRx.getUdpSocketTimeout());
                            TrueTimeRx.setSntpClient((SntpClient)sntpClient);
                        }
                        catch (Exception e) {
                            throw new RuntimeException(e);
                        }
                        return TrueTime.now();
                    }
                }).retry(50L).onErrorReturn((Func1)new Func1<Throwable, Date>(){

                    public Date call(Throwable throwable) {
                        throwable.printStackTrace();
                        return null;
                    }
                });
            }
        }, 3).filter((Func1)new Func1<Date, Boolean>(){

            public Boolean call(Date date) {
                return date != null;
            }
        }).first();
    }
}

