/*
 * Decompiled with CFR 0.152.
 */
package com.github.inspektr.audit;

import com.github.inspektr.audit.AuditActionContext;
import com.github.inspektr.audit.AuditTrailManager;
import com.github.inspektr.audit.annotation.Audit;
import com.github.inspektr.audit.annotation.Audits;
import com.github.inspektr.audit.spi.AuditActionResolver;
import com.github.inspektr.audit.spi.AuditResourceResolver;
import com.github.inspektr.common.spi.ClientInfoResolver;
import com.github.inspektr.common.spi.DefaultClientInfoResolver;
import com.github.inspektr.common.spi.PrincipalResolver;
import com.github.inspektr.common.web.ClientInfo;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Aspect
public final class AuditTrailManagementAspect {
    private final PrincipalResolver auditPrincipalResolver;
    private final Map<String, AuditActionResolver> auditActionResolvers;
    private final Map<String, AuditResourceResolver> auditResourceResolvers;
    private final List<AuditTrailManager> auditTrailManagers;
    private final String applicationCode;
    private ClientInfoResolver clientInfoResolver = new DefaultClientInfoResolver();

    public AuditTrailManagementAspect(String applicationCode, PrincipalResolver auditablePrincipalResolver, List<AuditTrailManager> auditTrailManagers, Map<String, AuditActionResolver> auditActionResolverMap, Map<String, AuditResourceResolver> auditResourceResolverMap) {
        this.auditPrincipalResolver = auditablePrincipalResolver;
        this.auditTrailManagers = auditTrailManagers;
        this.applicationCode = applicationCode;
        this.auditActionResolvers = auditActionResolverMap;
        this.auditResourceResolvers = auditResourceResolverMap;
    }

    @Around(value="@annotation(audits)", argNames="audits")
    public Object handleAuditTrail(ProceedingJoinPoint joinPoint, Audits audits) throws Throwable {
        Object retVal = null;
        String currentPrincipal = null;
        String[] actions = new String[audits.value().length];
        String[][] auditableResources = new String[audits.value().length][];
        try {
            retVal = joinPoint.proceed();
            currentPrincipal = this.auditPrincipalResolver.resolveFrom((JoinPoint)joinPoint, retVal);
            if (currentPrincipal != null) {
                for (int i = 0; i < audits.value().length; ++i) {
                    AuditActionResolver auditActionResolver = this.auditActionResolvers.get(audits.value()[i].actionResolverName());
                    AuditResourceResolver auditResourceResolver = this.auditResourceResolvers.get(audits.value()[i].resourceResolverName());
                    auditableResources[i] = auditResourceResolver.resolveFrom((JoinPoint)joinPoint, retVal);
                    actions[i] = auditActionResolver.resolveFrom((JoinPoint)joinPoint, retVal, audits.value()[i]);
                }
            }
            Object i = retVal;
            return i;
        }
        catch (Exception e) {
            currentPrincipal = this.auditPrincipalResolver.resolveFrom((JoinPoint)joinPoint, e);
            if (currentPrincipal != null) {
                for (int i = 0; i < audits.value().length; ++i) {
                    auditableResources[i] = this.auditResourceResolvers.get(audits.value()[i].resourceResolverName()).resolveFrom((JoinPoint)joinPoint, e);
                    actions[i] = this.auditActionResolvers.get(audits.value()[i].actionResolverName()).resolveFrom((JoinPoint)joinPoint, e, audits.value()[i]);
                }
            }
            throw e;
        }
        finally {
            for (int i = 0; i < audits.value().length; ++i) {
                this.executeAuditCode(currentPrincipal, auditableResources[i], joinPoint, retVal, actions[i], audits.value()[i]);
            }
        }
    }

    @Around(value="@annotation(audit)", argNames="audit")
    public Object handleAuditTrail(ProceedingJoinPoint joinPoint, Audit audit) throws Throwable {
        AuditActionResolver auditActionResolver = this.auditActionResolvers.get(audit.actionResolverName());
        AuditResourceResolver auditResourceResolver = this.auditResourceResolvers.get(audit.resourceResolverName());
        String currentPrincipal = null;
        String[] auditResource = null;
        String action = null;
        Object retVal = null;
        try {
            retVal = joinPoint.proceed();
            currentPrincipal = this.auditPrincipalResolver.resolveFrom((JoinPoint)joinPoint, retVal);
            auditResource = auditResourceResolver.resolveFrom((JoinPoint)joinPoint, retVal);
            action = auditActionResolver.resolveFrom((JoinPoint)joinPoint, retVal, audit);
            Object object = retVal;
            this.executeAuditCode(currentPrincipal, auditResource, joinPoint, retVal, action, audit);
            return object;
        }
        catch (Exception e) {
            try {
                currentPrincipal = this.auditPrincipalResolver.resolveFrom((JoinPoint)joinPoint, e);
                auditResource = auditResourceResolver.resolveFrom((JoinPoint)joinPoint, e);
                action = auditActionResolver.resolveFrom((JoinPoint)joinPoint, e, audit);
                throw e;
            }
            catch (Throwable throwable) {
                this.executeAuditCode(currentPrincipal, auditResource, joinPoint, retVal, action, audit);
                throw throwable;
            }
        }
    }

    private void executeAuditCode(String currentPrincipal, String[] auditableResources, ProceedingJoinPoint joinPoint, Object retVal, String action, Audit audit) {
        String applicationCode = audit.applicationCode() != null && audit.applicationCode().length() > 0 ? audit.applicationCode() : this.applicationCode;
        ClientInfo clientInfo = this.clientInfoResolver.resolveFrom((JoinPoint)joinPoint, retVal);
        Date actionDate = new Date();
        for (String auditableResource : auditableResources) {
            AuditActionContext auditContext = new AuditActionContext(currentPrincipal, auditableResource, action, applicationCode, actionDate, clientInfo.getClientIpAddress(), clientInfo.getServerIpAddress());
            for (AuditTrailManager manager : this.auditTrailManagers) {
                manager.record(auditContext);
            }
        }
    }

    public void setClientInfoResolver(ClientInfoResolver factory) {
        this.clientInfoResolver = factory;
    }
}

