/*
 * Decompiled with CFR 0.152.
 */
package com.github.inspektr.audit;

import java.io.Serializable;
import java.util.Date;

public final class AuditActionContext
implements Serializable {
    private static final long serialVersionUID = -3530737409883959089L;
    private final String principal;
    private final String resourceOperatedUpon;
    private final String actionPerformed;
    private final String applicationCode;
    private final Date whenActionWasPerformed;
    private final String clientIpAddress;
    private final String serverIpAddress;

    public AuditActionContext(String principal, String resourceOperatedUpon, String actionPerformed, String applicationCode, Date whenActionWasPerformed, String clientIpAddress, String serverIpAddress) {
        this.assertNotNull(principal, "principal cannot be null");
        this.assertNotNull(resourceOperatedUpon, "resourceOperatedUpon cannot be null");
        this.assertNotNull(actionPerformed, "actionPerformed cannot be null.");
        this.assertNotNull(applicationCode, "applicationCode cannot be null.");
        this.assertNotNull(whenActionWasPerformed, "whenActionPerformed cannot be null.");
        this.assertNotNull(clientIpAddress, "clientIpAddress cannot be null.");
        this.assertNotNull(serverIpAddress, "serverIpAddress cannot be null.");
        this.principal = principal;
        this.resourceOperatedUpon = resourceOperatedUpon;
        this.actionPerformed = actionPerformed;
        this.applicationCode = applicationCode;
        this.whenActionWasPerformed = new Date(whenActionWasPerformed.getTime());
        this.clientIpAddress = clientIpAddress;
        this.serverIpAddress = serverIpAddress;
    }

    protected void assertNotNull(Object o, String message) {
        if (o == null) {
            throw new IllegalArgumentException(message);
        }
    }

    public String getPrincipal() {
        return this.principal;
    }

    public String getResourceOperatedUpon() {
        return this.resourceOperatedUpon;
    }

    public String getActionPerformed() {
        return this.actionPerformed;
    }

    public String getApplicationCode() {
        return this.applicationCode;
    }

    public Date getWhenActionWasPerformed() {
        return new Date(this.whenActionWasPerformed.getTime());
    }

    public String getClientIpAddress() {
        return this.clientIpAddress;
    }

    public String getServerIpAddress() {
        return this.serverIpAddress;
    }
}

