/*
 * Decompiled with CFR 0.152.
 */
package com.jeevandeshmukh.glidetoastlib;

import android.app.Activity;
import android.app.Dialog;
import android.content.Context;
import android.graphics.Color;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.jeevandeshmukh.glidetoastlib.R;
import java.util.Timer;
import java.util.TimerTask;

public class GlideToast {
    private String message;
    private Activity activity;
    private int icon;
    public static int LENGTHTOOLONG = 1500;
    public static int LENGTHLONG = 1000;
    public static int LENGTHMEDIUM = 750;
    public static int LENGTHSHORT = 500;
    public static int LENGTHQUICK = 250;
    public static int TOP = 1;
    public static int CENTER = 2;
    public static int BOTTOM = 3;
    public static String DEFAULTTOAST = "DEFAULT";
    public static String SUCCESSTOAST = "SUCCESS";
    public static String FAILTOAST = "FAIL";
    public static String WARNINGTOAST = "WARN";
    public static String INFOTOAST = "INFO";
    public static String CUSTOMTOAST = "CUSTOM";

    private GlideToast() {
    }

    public static class makeToast {
        private String message;
        private Activity activity;
        private int icon;
        private int duration;
        private int gravity;
        private String style;
        private String backgroundcolor;
        TextView messageTV;
        ImageView iconImg;
        Dialog dialog;
        LinearLayout background;

        public makeToast(Activity activity, String message, int duration, String style2, int gravity) {
            this.activity = activity;
            this.message = message;
            this.duration = duration;
            this.style = style2;
            this.gravity = gravity;
        }

        public makeToast(Activity activity, String message, int duration, String style2) {
            this.activity = activity;
            this.message = message;
            this.duration = duration;
            this.style = style2;
        }

        public makeToast(Activity activity, String message, int duration) {
            this.activity = activity;
            this.message = message;
            this.duration = duration;
        }

        public makeToast(Activity activity, String message, int duration, String style2, int gravity, int icon, String backgroundcolor) {
            this.activity = activity;
            this.message = message;
            this.duration = duration;
            this.style = style2;
            this.icon = icon;
            this.backgroundcolor = backgroundcolor;
            this.gravity = gravity;
        }

        public void setStyle(String style2, LinearLayout background, ImageView iconImg) {
            switch (style2) {
                case "SUCCESS": {
                    background.setBackgroundResource(R.drawable.success_shape);
                    iconImg.setImageResource(R.drawable.ic_check_black_24dp);
                    break;
                }
                case "FAIL": {
                    background.setBackgroundResource(R.drawable.error_shape);
                    iconImg.setImageResource(R.drawable.ic_clear_black_24dp);
                    break;
                }
                case "WARN": {
                    background.setBackgroundResource(R.drawable.warning_shape);
                    iconImg.setImageResource(R.drawable.ic_pan_tool_black_24dp);
                    break;
                }
                case "INFO": {
                    background.setBackgroundResource(R.drawable.info_shape);
                    iconImg.setImageResource(R.drawable.ic_info_outline_black_24dp);
                    break;
                }
                case "CUSTOM": {
                    background.setBackgroundColor(Color.parseColor((String)this.backgroundcolor));
                    iconImg.setImageResource(this.icon);
                    break;
                }
                default: {
                    background.setBackgroundResource(R.drawable.default_shape);
                    iconImg.setImageResource(R.drawable.ic_info_outline_black_24dp);
                }
            }
        }

        public void setGravity(int gravity, Dialog dialog) {
            switch (gravity) {
                case 1: {
                    dialog.getWindow().setGravity(48);
                    break;
                }
                case 2: {
                    dialog.getWindow().setGravity(17);
                    break;
                }
                case 3: {
                    dialog.getWindow().setGravity(80);
                    break;
                }
                default: {
                    dialog.getWindow().setGravity(80);
                }
            }
        }

        public void show() {
            this.dialog = new Dialog((Context)this.activity, R.style.BottomDialogTheme);
            this.dialog.requestWindowFeature(1);
            this.dialog.setCancelable(true);
            this.dialog.setContentView(R.layout.item_toast);
            this.dialog.getWindow().setLayout(-1, -2);
            this.setGravity(this.gravity, this.dialog);
            this.messageTV = (TextView)this.dialog.findViewById(R.id.toast_text);
            this.iconImg = (ImageView)this.dialog.findViewById(R.id.toast_icon);
            this.background = (LinearLayout)this.dialog.findViewById(R.id.background);
            this.messageTV.setText((CharSequence)this.message);
            this.dialog.setCancelable(true);
            this.setStyle(this.style, this.background, this.iconImg);
            this.dialog.show();
            new Timer().schedule(new TimerTask(){

                @Override
                public void run() {
                    makeToast.this.dialog.dismiss();
                }
            }, this.duration);
        }
    }
}

