/*
 * Decompiled with CFR 0.152.
 */
package com.github.iielse.imageviewer.viewholders;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import androidx.recyclerview.widget.RecyclerView;
import com.github.iielse.imageviewer.ImageViewerAdapterListener;
import com.github.iielse.imageviewer.R;
import com.github.iielse.imageviewer.core.Components;
import com.github.iielse.imageviewer.core.ImageLoader;
import com.github.iielse.imageviewer.core.Photo;
import com.github.iielse.imageviewer.databinding.ItemImageviewerVideoBinding;
import com.github.iielse.imageviewer.widgets.video.ExoVideoView2;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000f"}, d2={"Lcom/github/iielse/imageviewer/viewholders/VideoViewHolder;", "Landroidx/recyclerview/widget/RecyclerView$ViewHolder;", "parent", "Landroid/view/ViewGroup;", "callback", "Lcom/github/iielse/imageviewer/ImageViewerAdapterListener;", "binding", "Lcom/github/iielse/imageviewer/databinding/ItemImageviewerVideoBinding;", "(Landroid/view/ViewGroup;Lcom/github/iielse/imageviewer/ImageViewerAdapterListener;Lcom/github/iielse/imageviewer/databinding/ItemImageviewerVideoBinding;)V", "getBinding", "()Lcom/github/iielse/imageviewer/databinding/ItemImageviewerVideoBinding;", "bind", "", "item", "Lcom/github/iielse/imageviewer/core/Photo;", "imageviewer_release"})
public final class VideoViewHolder
extends RecyclerView.ViewHolder {
    @NotNull
    private final ItemImageviewerVideoBinding binding;

    public VideoViewHolder(@NotNull ViewGroup parent, final @NotNull ImageViewerAdapterListener callback2, @NotNull ItemImageviewerVideoBinding binding) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        Intrinsics.checkNotNullParameter((Object)callback2, (String)"callback");
        Intrinsics.checkNotNullParameter((Object)binding, (String)"binding");
        super((View)binding.getRoot());
        this.binding = binding;
        this.binding.videoView.addListener(new ExoVideoView2.Listener(){

            @Override
            public void onDrag(@NotNull ExoVideoView2 view, float fraction) {
                Intrinsics.checkNotNullParameter((Object)((Object)view), (String)"view");
                callback2.onDrag(this, (View)view, fraction);
            }

            @Override
            public void onRestore(@NotNull ExoVideoView2 view, float fraction) {
                Intrinsics.checkNotNullParameter((Object)((Object)view), (String)"view");
                callback2.onRestore(this, (View)view, fraction);
            }

            @Override
            public void onRelease(@NotNull ExoVideoView2 view) {
                Intrinsics.checkNotNullParameter((Object)((Object)view), (String)"view");
                callback2.onRelease(this, (View)view);
            }
        });
        Components.INSTANCE.requireVHCustomizer().initialize(3, this);
    }

    public /* synthetic */ VideoViewHolder(ViewGroup viewGroup, ImageViewerAdapterListener imageViewerAdapterListener, ItemImageviewerVideoBinding itemImageviewerVideoBinding, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            ItemImageviewerVideoBinding itemImageviewerVideoBinding2 = ItemImageviewerVideoBinding.inflate(LayoutInflater.from((Context)viewGroup.getContext()), viewGroup, false);
            Intrinsics.checkNotNullExpressionValue((Object)itemImageviewerVideoBinding2, (String)"<init>");
            itemImageviewerVideoBinding = itemImageviewerVideoBinding2;
        }
        this(viewGroup, imageViewerAdapterListener, itemImageviewerVideoBinding);
    }

    @NotNull
    public final ItemImageviewerVideoBinding getBinding() {
        return this.binding;
    }

    public final void bind(@NotNull Photo item) {
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        this.binding.videoView.setTag(R.id.viewer_adapter_item_key, item.id());
        this.binding.videoView.setTag(R.id.viewer_adapter_item_data, item);
        this.binding.videoView.setTag(R.id.viewer_adapter_item_holder, (Object)this);
        Components.INSTANCE.requireVHCustomizer().bind(3, item, this);
        ImageLoader imageLoader = Components.INSTANCE.requireImageLoader();
        ExoVideoView2 exoVideoView2 = this.binding.videoView;
        Intrinsics.checkNotNullExpressionValue((Object)((Object)exoVideoView2), (String)"binding.videoView");
        imageLoader.load(exoVideoView2, item, (RecyclerView.ViewHolder)this);
    }
}

