/*
 * Decompiled with CFR 0.152.
 */
package com.github.iielse.imageviewer;

import android.content.Context;
import androidx.fragment.app.FragmentActivity;
import com.github.iielse.imageviewer.ImageViewerDialogFragment;
import com.github.iielse.imageviewer.core.Components;
import com.github.iielse.imageviewer.core.DataProvider;
import com.github.iielse.imageviewer.core.ImageLoader;
import com.github.iielse.imageviewer.core.OverlayCustomizer;
import com.github.iielse.imageviewer.core.Transformer;
import com.github.iielse.imageviewer.core.VHCustomizer;
import com.github.iielse.imageviewer.core.ViewerCallback;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B'\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\b\u0010\u0013\u001a\u00020\u0014H\u0002J\u0010\u0010\u0015\u001a\u00020\u00002\b\u0010\r\u001a\u0004\u0018\u00010\u000eJ\u000e\u0010\u0016\u001a\u00020\u00002\u0006\u0010\u000f\u001a\u00020\u0010J\u000e\u0010\u0017\u001a\u00020\u00002\u0006\u0010\u0011\u001a\u00020\u0012J\u0010\u0010\u0018\u001a\u00020\u00002\b\u0010\u000b\u001a\u0004\u0018\u00010\fJ\u0006\u0010\u0019\u001a\u00020\u001aR\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/github/iielse/imageviewer/ImageViewerBuilder;", "", "context", "Landroid/content/Context;", "imageLoader", "Lcom/github/iielse/imageviewer/core/ImageLoader;", "dataProvider", "Lcom/github/iielse/imageviewer/core/DataProvider;", "transformer", "Lcom/github/iielse/imageviewer/core/Transformer;", "(Landroid/content/Context;Lcom/github/iielse/imageviewer/core/ImageLoader;Lcom/github/iielse/imageviewer/core/DataProvider;Lcom/github/iielse/imageviewer/core/Transformer;)V", "factory", "Lcom/github/iielse/imageviewer/ImageViewerDialogFragment$Factory;", "overlayCustomizer", "Lcom/github/iielse/imageviewer/core/OverlayCustomizer;", "vhCustomizer", "Lcom/github/iielse/imageviewer/core/VHCustomizer;", "viewerCallback", "Lcom/github/iielse/imageviewer/core/ViewerCallback;", "create", "Lcom/github/iielse/imageviewer/ImageViewerDialogFragment;", "setOverlayCustomizer", "setVHCustomizer", "setViewerCallback", "setViewerFactory", "show", "", "imageviewer_release"})
public final class ImageViewerBuilder {
    @Nullable
    private final Context context;
    @NotNull
    private final ImageLoader imageLoader;
    @NotNull
    private final DataProvider dataProvider;
    @NotNull
    private final Transformer transformer;
    @Nullable
    private VHCustomizer vhCustomizer;
    @Nullable
    private ViewerCallback viewerCallback;
    @Nullable
    private OverlayCustomizer overlayCustomizer;
    @Nullable
    private ImageViewerDialogFragment.Factory factory;

    public ImageViewerBuilder(@Nullable Context context, @NotNull ImageLoader imageLoader, @NotNull DataProvider dataProvider2, @NotNull Transformer transformer2) {
        Intrinsics.checkNotNullParameter((Object)imageLoader, (String)"imageLoader");
        Intrinsics.checkNotNullParameter((Object)dataProvider2, (String)"dataProvider");
        Intrinsics.checkNotNullParameter((Object)transformer2, (String)"transformer");
        this.context = context;
        this.imageLoader = imageLoader;
        this.dataProvider = dataProvider2;
        this.transformer = transformer2;
    }

    @NotNull
    public final ImageViewerBuilder setVHCustomizer(@NotNull VHCustomizer vhCustomizer) {
        Intrinsics.checkNotNullParameter((Object)vhCustomizer, (String)"vhCustomizer");
        this.vhCustomizer = vhCustomizer;
        return this;
    }

    @NotNull
    public final ImageViewerBuilder setViewerCallback(@NotNull ViewerCallback viewerCallback) {
        Intrinsics.checkNotNullParameter((Object)viewerCallback, (String)"viewerCallback");
        this.viewerCallback = viewerCallback;
        return this;
    }

    @NotNull
    public final ImageViewerBuilder setOverlayCustomizer(@Nullable OverlayCustomizer overlayCustomizer) {
        this.overlayCustomizer = overlayCustomizer;
        return this;
    }

    @NotNull
    public final ImageViewerBuilder setViewerFactory(@Nullable ImageViewerDialogFragment.Factory factory) {
        this.factory = factory;
        return this;
    }

    private final ImageViewerDialogFragment create() {
        ImageViewerDialogFragment.Factory factory = this.factory;
        return (factory == null ? new ImageViewerDialogFragment.Factory() : factory).build();
    }

    public final void show() {
        FragmentActivity fragmentActivity;
        if (Components.INSTANCE.getWorking()) {
            return;
        }
        Context context = this.context;
        FragmentActivity fragmentActivity2 = fragmentActivity = context instanceof FragmentActivity ? (FragmentActivity)context : null;
        if (fragmentActivity != null) {
            context = fragmentActivity;
            boolean bl = false;
            boolean bl2 = false;
            Context it = context;
            boolean bl3 = false;
            Components.INSTANCE.initialize(this.imageLoader, this.dataProvider, this.transformer);
            Components.INSTANCE.setVHCustomizer(this.vhCustomizer);
            Components.INSTANCE.setViewerCallback(this.viewerCallback);
            Components.INSTANCE.setOverlayCustomizer(this.overlayCustomizer);
            ImageViewerDialogFragment viewer = this.create();
            viewer.show(it.getSupportFragmentManager());
        }
    }
}

