/*
 * Decompiled with CFR 0.152.
 */
package com.ihsanbal.logging;

import com.ihsanbal.logging.Level;
import com.ihsanbal.logging.Logger;
import com.ihsanbal.logging.Printer;
import com.ihsanbal.logging.TextUtils;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import okhttp3.Headers;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;

public class LoggingInterceptor
implements Interceptor {
    private boolean isDebug;
    private Builder builder;

    private LoggingInterceptor(Builder builder) {
        this.builder = builder;
        this.isDebug = builder.isDebug;
    }

    public Response intercept(Interceptor.Chain chain) throws IOException {
        Request request = chain.request();
        if (this.builder.getHeaders().size() > 0) {
            Headers headers = request.headers();
            Set names = headers.names();
            Iterator iterator = names.iterator();
            Request.Builder requestBuilder = request.newBuilder();
            requestBuilder.headers(this.builder.getHeaders());
            while (iterator.hasNext()) {
                String name = (String)iterator.next();
                requestBuilder.addHeader(name, headers.get(name));
            }
            request = requestBuilder.build();
        }
        if (!this.isDebug || this.builder.getLevel() == Level.NONE) {
            return chain.proceed(request);
        }
        RequestBody requestBody = request.body();
        String rSubtype = null;
        if (requestBody != null && requestBody.contentType() != null) {
            rSubtype = requestBody.contentType().subtype();
        }
        if (rSubtype != null && (rSubtype.contains("json") || rSubtype.contains("xml") || rSubtype.contains("plain") || rSubtype.contains("html"))) {
            Printer.printJsonRequest(this.builder, request);
        } else {
            Printer.printFileRequest(this.builder, request);
        }
        long st = System.nanoTime();
        Response response = chain.proceed(request);
        long chainMs = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - st);
        List segmentList = request.url().encodedPathSegments();
        String header = response.headers().toString();
        int code = response.code();
        boolean isSuccessful = response.isSuccessful();
        String message = response.message();
        ResponseBody responseBody = response.body();
        MediaType contentType = responseBody.contentType();
        String subtype = null;
        if (contentType != null) {
            subtype = contentType.subtype();
        }
        if (subtype == null || !subtype.contains("json") && !subtype.contains("xml") && !subtype.contains("plain") && !subtype.contains("html")) {
            Printer.printFileResponse(this.builder, chainMs, isSuccessful, code, header, segmentList, message);
            return response;
        }
        String bodyString = Printer.getJsonString(responseBody.string());
        Printer.printJsonResponse(this.builder, chainMs, isSuccessful, code, header, bodyString, segmentList, message);
        ResponseBody body = ResponseBody.create((MediaType)contentType, (String)bodyString);
        return response.newBuilder().body(body).build();
    }

    public static class Builder {
        private static String TAG = "LoggingI";
        private boolean isDebug;
        private int type = 4;
        private String requestTag;
        private String responseTag;
        private Level level = Level.BASIC;
        private Headers.Builder builder = new Headers.Builder();
        private Logger logger;

        int getType() {
            return this.type;
        }

        Level getLevel() {
            return this.level;
        }

        Headers getHeaders() {
            return this.builder.build();
        }

        String getTag(boolean isRequest) {
            if (isRequest) {
                return TextUtils.isEmpty(this.requestTag) ? TAG : this.requestTag;
            }
            return TextUtils.isEmpty(this.responseTag) ? TAG : this.responseTag;
        }

        Logger getLogger() {
            return this.logger;
        }

        public Builder addHeader(String name, String value) {
            this.builder.set(name, value);
            return this;
        }

        public Builder setLevel(Level level) {
            this.level = level;
            return this;
        }

        public Builder tag(String tag) {
            TAG = tag;
            return this;
        }

        public Builder request(String tag) {
            this.requestTag = tag;
            return this;
        }

        public Builder response(String tag) {
            this.responseTag = tag;
            return this;
        }

        public Builder loggable(boolean isDebug) {
            this.isDebug = isDebug;
            return this;
        }

        public Builder log(int type) {
            this.type = type;
            return this;
        }

        public Builder logger(Logger logger) {
            this.logger = logger;
            return this;
        }

        public LoggingInterceptor build() {
            return new LoggingInterceptor(this);
        }
    }
}

