/*
 * Decompiled with CFR 0.152.
 */
package org.frutilla;

import org.frutilla.ExceptionUtils;
import org.frutilla.FrutillaParser;
import org.frutilla.annotations.Frutilla;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.Statement;

public class FrutillaTestRunner
extends BlockJUnit4ClassRunner {
    public FrutillaTestRunner(Class<?> klass) throws InitializationError {
        super(klass);
    }

    protected Statement methodBlock(FrameworkMethod method) {
        return new FrutillaStatement(super.methodBlock(method), method);
    }

    class FrutillaStatement
    extends Statement {
        private final Statement mStatement;
        private final FrameworkMethod mMethod;

        public FrutillaStatement(Statement statement, FrameworkMethod method) {
            this.mStatement = statement;
            this.mMethod = method;
        }

        public void evaluate() throws Throwable {
            String text = this.preEvaluate();
            try {
                this.mStatement.evaluate();
            }
            catch (Throwable exc) {
                if (!text.isEmpty()) {
                    ExceptionUtils.insertMessage(exc, text);
                }
                throw exc;
            }
        }

        private String preEvaluate() {
            StringBuffer sb = new StringBuffer();
            sb.append("\n");
            sb.append("/------------------------------------------\\\n");
            sb.append("Test: " + this.mMethod.getName() + "\n");
            sb.append("--------------------------------------------\n");
            String text = "";
            try {
                text = FrutillaParser.scenario((Frutilla)this.mMethod.getAnnotation(Frutilla.class));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (!text.isEmpty()) {
                sb.append(text + "\n");
            }
            sb.append("\\------------------------------------------/\n");
            sb.append("\n");
            System.out.println(sb.toString());
            return text;
        }
    }
}

