/*
 * Decompiled with CFR 0.152.
 */
package com.feilong.zip;

import com.feilong.core.CharsetType;
import com.feilong.core.Validator;
import com.feilong.io.FileUtil;
import com.feilong.io.IOUtil;
import com.feilong.zip.AbstractZipHandler;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompressZipHandler
extends AbstractZipHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(CompressZipHandler.class);

    @Override
    protected void handle(String tobeZipFilePath, String outputZipPath) throws IOException {
        FileOutputStream fileOutputStream = FileUtil.getFileOutputStream(outputZipPath);
        ZipArchiveOutputStream zipArchiveOutputStream = new ZipArchiveOutputStream((OutputStream)new BufferedOutputStream(fileOutputStream));
        zipArchiveOutputStream.setEncoding(CharsetType.UTF8);
        zipArchiveOutputStream.setMethod(8);
        zipArchiveOutputStream.setLevel(9);
        CompressZipHandler.zip(zipArchiveOutputStream, new File(tobeZipFilePath), "");
        zipArchiveOutputStream.close();
    }

    private static void zip(ZipArchiveOutputStream zipArchiveOutputStream, File willFile, String dirName) throws IOException {
        String fileName = willFile.getName();
        LOGGER.debug("will zip :[{}] to zip file", (Object)fileName);
        if (willFile.isFile()) {
            CompressZipHandler.putArchiveEntry(zipArchiveOutputStream, dirName + fileName);
            IOUtil.copy(FileUtil.getFileInputStream(willFile.getAbsolutePath()), (OutputStream)zipArchiveOutputStream);
            zipArchiveOutputStream.closeArchiveEntry();
            return;
        }
        File[] files = willFile.listFiles();
        if (Validator.isNullOrEmpty(files)) {
            CompressZipHandler.putArchiveEntry(zipArchiveOutputStream, dirName + willFile.getName() + File.separator);
            zipArchiveOutputStream.closeArchiveEntry();
            return;
        }
        for (File file : files) {
            CompressZipHandler.zip(zipArchiveOutputStream, file, dirName + fileName + File.separator);
        }
    }

    private static void putArchiveEntry(ZipArchiveOutputStream zipArchiveOutputStream, String name) {
        try {
            zipArchiveOutputStream.putArchiveEntry((ArchiveEntry)new ZipArchiveEntry(name));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

