/*
 * Decompiled with CFR 0.152.
 */
package com.feilong.zip;

import com.feilong.core.Validate;
import com.feilong.core.date.DateUtil;
import com.feilong.tools.slf4j.Slf4jUtil;
import com.feilong.zip.ZipHandler;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractZipHandler
implements ZipHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractZipHandler.class);

    @Override
    public void zip(String tobeZipFilePath, String outputZipPath) {
        Validate.notBlank(tobeZipFilePath, "tobeZipFilePath can't be blank!", new Object[0]);
        Validate.notBlank(outputZipPath, "outputZipPath can't be blank!", new Object[0]);
        Date beginDate = DateUtil.now();
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("begin zip:[{}] to outputZipPath:[{}]", (Object)tobeZipFilePath, (Object)outputZipPath);
        }
        try {
            this.handle(tobeZipFilePath, outputZipPath);
        }
        catch (IOException e) {
            String message = Slf4jUtil.format("tobeZipFilePath:[{}],outputZipPath:[{}]", tobeZipFilePath, outputZipPath);
            throw new UncheckedIOException(message, e);
        }
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("use time:[{}],end zip:[{}],outputZipPath:[{}]", new Object[]{DateUtil.formatDuration(beginDate), tobeZipFilePath, outputZipPath});
        }
    }

    protected abstract void handle(String var1, String var2) throws IOException;
}

