/*
 * Decompiled with CFR 0.152.
 */
package com.feilong.validator;

import com.feilong.core.Validate;
import com.feilong.core.Validator;
import com.feilong.core.util.RegexUtil;
import com.feilong.lib.validator.EmailValidator;
import com.feilong.validator.RegexPattern;

public final class ValidatorUtil {
    private ValidatorUtil() {
        throw new AssertionError((Object)("No " + this.getClass().getName() + " instances for you!"));
    }

    public static boolean isTelephone(String telephone) {
        return ValidatorUtil.isMatches(RegexPattern.TELEPHONE, telephone);
    }

    public static boolean isTelephoneMustAreacode(String telephoneMustAreacode) {
        return ValidatorUtil.isMatches(RegexPattern.TELEPHONE_MUST_AREACODE, telephoneMustAreacode);
    }

    public static boolean isZipcode(String zipcode) {
        return ValidatorUtil.isMatches(RegexPattern.ZIPCODE, zipcode);
    }

    public static boolean isMobile(String mobile) {
        return ValidatorUtil.isMatches(RegexPattern.MOBILEPHONE, mobile);
    }

    public static boolean isEmail(String email) {
        if (Validator.isNullOrEmpty(email)) {
            return false;
        }
        EmailValidator emailValidator = EmailValidator.getInstance();
        return emailValidator.isValid(email);
    }

    public static boolean isMatches(String pattern, String input) {
        Validate.notBlank(pattern, "pattern can't be blank!", new Object[0]);
        return RegexUtil.matches(pattern, input);
    }
}

