/*
 * Decompiled with CFR 0.152.
 */
package com.feilong.taglib.display.pager.command;

import java.io.Serializable;
import java.util.List;

public final class Pager<T>
implements Serializable {
    private static final long serialVersionUID = -903770720729924696L;
    private Integer currentPageNo;
    private Integer pageSize = 10;
    private Integer count;
    private List<T> itemList;
    private Integer maxShowPageNo;

    public Pager() {
    }

    public Pager(Integer currentPageNo, Integer pageSize, Integer count) {
        this.currentPageNo = currentPageNo;
        this.pageSize = pageSize;
        this.count = count;
    }

    public int getAllPageNo() {
        boolean isMaxShowPageNoDecorate = null != this.maxShowPageNo && this.maxShowPageNo != -1 && this.maxShowPageNo > 0;
        int originatingAllPageNo = this.getOriginatingAllPageNo();
        if (!isMaxShowPageNoDecorate) {
            return originatingAllPageNo;
        }
        return originatingAllPageNo <= this.maxShowPageNo ? originatingAllPageNo : this.maxShowPageNo;
    }

    public int getOriginatingAllPageNo() {
        if (0 == this.count) {
            return 0;
        }
        if (this.count < this.pageSize) {
            return 1;
        }
        int i = this.count / this.pageSize;
        return this.count % this.pageSize == 0 ? i : i + 1;
    }

    public int getPrePageNo() {
        int prePageNo = this.currentPageNo - 1;
        return prePageNo <= 1 ? 1 : prePageNo;
    }

    public int getNextPageNo() {
        int allPageNo = this.getAllPageNo();
        int nextPage = this.currentPageNo + 1;
        return nextPage >= allPageNo ? allPageNo : nextPage;
    }

    public int getOriginatingNextPageNo() {
        int originatingAllPageNo = this.getOriginatingAllPageNo();
        int nextPage = this.currentPageNo + 1;
        return nextPage >= originatingAllPageNo ? originatingAllPageNo : nextPage;
    }

    public Integer getCurrentPageNo() {
        return this.currentPageNo;
    }

    public void setCurrentPageNo(Integer currentPageNo) {
        this.currentPageNo = currentPageNo;
    }

    public Integer getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public Integer getCount() {
        return this.count;
    }

    public void setCount(Integer count) {
        this.count = count;
    }

    public Integer getMaxShowPageNo() {
        return this.maxShowPageNo;
    }

    public void setMaxShowPageNo(Integer maxShowPageNo) {
        this.maxShowPageNo = maxShowPageNo;
    }

    public List<T> getItemList() {
        return this.itemList;
    }

    public void setItemList(List<T> itemList) {
        this.itemList = itemList;
    }
}

