/*
 * Decompiled with CFR 0.152.
 */
package com.feilong.taglib.display.pager;

import com.feilong.core.Validate;
import com.feilong.json.JsonUtil;
import com.feilong.taglib.display.SimpleTagParamCacheManager;
import com.feilong.taglib.display.pager.PagerCacheContentBuilder;
import com.feilong.taglib.display.pager.command.Pager;
import com.feilong.taglib.display.pager.command.PagerAndContent;
import com.feilong.taglib.display.pager.command.PagerParams;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PagerBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(PagerBuilder.class);

    private PagerBuilder() {
        throw new AssertionError((Object)("No " + this.getClass().getName() + " instances for you!"));
    }

    public static <T> PagerAndContent<T> buildPagerAndContent(PagerParams pagerParams, List<T> itemList) {
        Pager<T> pager = PagerCacheContentBuilder.buildPager(pagerParams);
        pager.setItemList(itemList);
        return new PagerAndContent(pager, PagerBuilder.buildContent(pagerParams));
    }

    public static String buildContent(PagerParams pagerParams) {
        Validate.notNull(pagerParams, "pagerParams can't be null!", new Object[0]);
        if (pagerParams.getTotalCount() <= 0) {
            LOGGER.debug("totalCount value is [{}] not > 0,will return empty", (Object)pagerParams.getTotalCount());
            return "";
        }
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("input [pagerParams] info:{}", (Object)JsonUtil.format(pagerParams));
        }
        return SimpleTagParamCacheManager.getContent(pagerParams, PagerCacheContentBuilder.INSTANCE);
    }
}

