/*
 * Decompiled with CFR 0.152.
 */
package com.feilong.taglib.display.httpconcat.handler;

import com.feilong.core.Validate;
import com.feilong.core.Validator;
import com.feilong.core.lang.StringUtil;
import com.feilong.core.util.CollectionsUtil;
import com.feilong.taglib.display.httpconcat.handler.ItemSrcExtractor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ItemSrcListResolver {
    private static final Logger LOGGER = LoggerFactory.getLogger(ItemSrcListResolver.class);

    private ItemSrcListResolver() {
        throw new AssertionError((Object)("No " + this.getClass().getName() + " instances for you!"));
    }

    public static List<String> resolve(String blockContent, String domain) {
        Validate.notBlank(blockContent, "blockContent can't be blank!", new Object[0]);
        String[] items = StringUtil.split(blockContent.trim(), "\n");
        int length = items.length;
        ArrayList<String> list = new ArrayList<String>(length);
        for (int i = 0; i < length; ++i) {
            String item = items[i];
            if (ItemSrcListResolver.isIgnore(item)) continue;
            list.add(ItemSrcExtractor.extract(item, domain));
        }
        if (Validator.isNullOrEmpty(list)) {
            if (LOGGER.isWarnEnabled()) {
                LOGGER.warn("list isNullOrEmpty,need list to create links,now return emptyList(),blockContent info:[{}],domain:[{}]", (Object)blockContent, (Object)domain);
            }
            return Collections.emptyList();
        }
        return ItemSrcListResolver.rework(blockContent, list);
    }

    private static boolean isIgnore(String item) {
        if (Validator.isNullOrEmpty(item)) {
            return true;
        }
        return item.trim().startsWith("<!--");
    }

    private static List<String> rework(String blockContent, List<String> itemSrcList) {
        Validate.notEmpty(itemSrcList, "itemSrcList can't be null/empty!", new Object[0]);
        List<String> noRepeatItemList = CollectionsUtil.removeDuplicate(itemSrcList);
        int noRepeatitemListSize = noRepeatItemList.size();
        int itemSrcListSize = itemSrcList.size();
        if (noRepeatitemListSize != itemSrcListSize && LOGGER.isWarnEnabled()) {
            LOGGER.warn("noRepeatList.size:[{}]!= srcList.size:[{}],blockContent:{}", new Object[]{noRepeatitemListSize, itemSrcListSize, blockContent});
        }
        return noRepeatItemList;
    }
}

