/*
 * Decompiled with CFR 0.152.
 */
package com.feilong.taglib.display.httpconcat.builder;

import com.feilong.core.Validator;
import com.feilong.core.date.DateUtil;
import com.feilong.lib.lang3.StringUtils;
import com.feilong.taglib.TagUtils;
import com.feilong.taglib.display.httpconcat.builder.HttpConcatGlobalConfigBuilder;
import javax.servlet.jsp.PageContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VersionRebuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(VersionRebuilder.class);

    private VersionRebuilder() {
        throw new AssertionError((Object)("No " + this.getClass().getName() + " instances for you!"));
    }

    public static String rebuild(String version, PageContext pageContext) {
        String versionValue = VersionRebuilder.build(version, pageContext);
        return VersionRebuilder.doWithAutoRefresh(versionValue);
    }

    static String doWithAutoRefresh(String versionValue) {
        String versionAutoRefreshValue = HttpConcatGlobalConfigBuilder.GLOBAL_CONFIG.getVersionAutoRefreshValue();
        if (Validator.isNotNullOrEmpty(versionAutoRefreshValue) && StringUtils.equals(versionValue, versionAutoRefreshValue)) {
            long time = DateUtil.getTime(DateUtil.now());
            String result = "" + time;
            LOGGER.debug("versionAutoRefreshValue config:[{}],new value is:[{}]", (Object)versionAutoRefreshValue, (Object)result);
            return result;
        }
        return versionValue;
    }

    private static String build(String version, PageContext pageContext) {
        if (Validator.isNotNullOrEmpty(version)) {
            return version;
        }
        String versionNameInScope = HttpConcatGlobalConfigBuilder.GLOBAL_CONFIG.getVersionNameInScope();
        if (Validator.isNullOrEmpty(versionNameInScope)) {
            LOGGER.debug("version is null or empty,and can't find versionNameInScope in GLOBAL_CONFIG,return empty!!");
            return "";
        }
        String versionSearchScope = HttpConcatGlobalConfigBuilder.GLOBAL_CONFIG.getVersionSearchScope();
        String versionValue = (String)TagUtils.findAttributeValue(pageContext, versionNameInScope, versionSearchScope);
        if (Validator.isNullOrEmpty(versionValue)) {
            LOGGER.warn("in GLOBAL_CONFIG,versionNameInScope:[{}] searchScope:[{}],but can't get value", (Object)versionNameInScope, (Object)versionSearchScope);
            return "";
        }
        LOGGER.debug("in Scope:[{}] find name:[{}],versionValue:[{}]", new Object[]{versionSearchScope, versionNameInScope, versionValue});
        return versionValue;
    }
}

