/*
 * Decompiled with CFR 0.152.
 */
package com.feilong.taglib.display.httpconcat;

import com.feilong.core.Validate;
import com.feilong.core.Validator;
import com.feilong.core.util.MapUtil;
import com.feilong.json.JsonUtil;
import com.feilong.taglib.display.httpconcat.builder.HttpConcatGlobalConfigBuilder;
import com.feilong.taglib.display.httpconcat.builder.ResultBuilder;
import com.feilong.taglib.display.httpconcat.command.HttpConcatParam;
import com.feilong.taglib.display.httpconcat.handler.ItemSrcListResolver;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HttpConcatUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpConcatUtil.class);
    private static final Map<HttpConcatParam, String> CACHE = MapUtil.newConcurrentHashMap(500);

    private HttpConcatUtil() {
        throw new AssertionError((Object)("No " + this.getClass().getName() + " instances for you!"));
    }

    public static String getWriteContent(HttpConcatParam httpConcatParam) {
        List<String> itemSrcList;
        boolean cacheEnable;
        Validate.notNull(httpConcatParam, "httpConcatParam can't be null!", new Object[0]);
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("input httpConcatParam info:[{}]", (Object)JsonUtil.format(httpConcatParam));
        }
        if (cacheEnable = HttpConcatGlobalConfigBuilder.GLOBAL_CONFIG.getDefaultCacheEnable()) {
            int cacheSize = CACHE.size();
            int cacheKeyHashCode = httpConcatParam.hashCode();
            String content = CACHE.get(httpConcatParam);
            if (null == content) {
                LOGGER.debug("concatCache size:[{}] no contains current concatParam hashcode:[{}],will parse", (Object)cacheSize, (Object)cacheKeyHashCode);
            } else {
                LOGGER.debug("hashcode:[{}],get httpConcat info from httpConcatCache,cache.size:[{}]", (Object)cacheKeyHashCode, (Object)cacheSize);
                return content;
            }
        }
        if (Validator.isNullOrEmpty(itemSrcList = ItemSrcListResolver.resolve(httpConcatParam.getContent(), httpConcatParam.getDomain()))) {
            if (LOGGER.isWarnEnabled()) {
                LOGGER.warn("need itemSrcList to create links but isNullOrEmpty,return [empty],httpConcatParam info:[{}]", (Object)JsonUtil.format(httpConcatParam));
            }
            return "";
        }
        String content = ResultBuilder.build(itemSrcList, httpConcatParam);
        HttpConcatUtil.after(content, HttpConcatUtil.isWriteCache(cacheEnable, httpConcatParam), httpConcatParam);
        return content;
    }

    private static boolean isWriteCache(boolean cacheEnable, HttpConcatParam httpConcatParam) {
        int defaultSizeLimit;
        boolean outOfCacheItemSizeLimit;
        if (!cacheEnable) {
            return false;
        }
        int cacheSize = CACHE.size();
        boolean bl = outOfCacheItemSizeLimit = cacheSize >= (defaultSizeLimit = HttpConcatGlobalConfigBuilder.GLOBAL_CONFIG.getDefaultCacheSizeLimit());
        if (!outOfCacheItemSizeLimit) {
            return true;
        }
        int hashCode = httpConcatParam.hashCode();
        LOGGER.warn("hashcode:[{}],cache.size:[{}] >= defaultSizeLimit:[{}],will not put to cache", new Object[]{hashCode, cacheSize, defaultSizeLimit});
        return false;
    }

    private static void after(String content, boolean isWriteCache, HttpConcatParam httpConcatParam) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("return content:[{}],length:[{}]", (Object)content, (Object)content.length());
        }
        int hashCode = httpConcatParam.hashCode();
        if (isWriteCache) {
            CACHE.put(httpConcatParam, content);
            LOGGER.debug("hashcode:[{}] put to cache,cache size:[{}]", (Object)hashCode, (Object)CACHE.size());
            return;
        }
        if (HttpConcatGlobalConfigBuilder.GLOBAL_CONFIG.getDefaultCacheEnable()) {
            LOGGER.warn("hashcode:[{}],DEFAULT_CACHEENABLE:[true],but writeCache:[false],so httpConcat result not put to cache", (Object)hashCode);
        }
    }
}

