/*
 * Decompiled with CFR 0.152.
 */
package com.feilong.taglib.display.httpconcat;

import com.feilong.core.Validator;
import com.feilong.lib.lang3.StringUtils;
import com.feilong.taglib.AbstractEndWriteContentTag;
import com.feilong.taglib.CacheTag;
import com.feilong.taglib.display.httpconcat.HttpConcatUtil;
import com.feilong.taglib.display.httpconcat.builder.DomainRebuilder;
import com.feilong.taglib.display.httpconcat.builder.HttpConcatParamBuilder;
import com.feilong.taglib.display.httpconcat.builder.VersionRebuilder;
import com.feilong.taglib.display.httpconcat.command.HttpConcatParam;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpConcatTag
extends AbstractEndWriteContentTag
implements CacheTag {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpConcatTag.class);
    private static final long serialVersionUID = -3447592871482978718L;
    private String type;
    private String version;
    private String root;
    private String domain;
    private Boolean httpConcatSupport = null;
    private String rebuildVersion;
    private String rebuildDomain;

    @Override
    protected Object buildContent(HttpServletRequest request) {
        String bodyContentSrc = this.bodyContent.getString();
        if (Validator.isNullOrEmpty(bodyContentSrc)) {
            LOGGER.warn("bodyContentSrc is null or empty, return empty");
            return "";
        }
        this.rebuildDomain = DomainRebuilder.rebuild(this.domain, request);
        this.rebuildVersion = VersionRebuilder.rebuild(this.version, this.pageContext);
        HttpConcatParam httpConcatParam = HttpConcatParamBuilder.build(bodyContentSrc, this.type, this.rebuildDomain, this.root, this.rebuildVersion, this.httpConcatSupport);
        return HttpConcatUtil.getWriteContent(httpConcatParam);
    }

    @Override
    public String buildCacheTagKey() {
        return StringUtils.join(this.type, this.domain, this.root, this.version, this.httpConcatSupport, this.bodyContent.getString());
    }

    @Override
    protected String buildExtraKeyInfoToLog() {
        return "[type=" + this.type + "]";
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public void setRoot(String root) {
        this.root = root;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public void setHttpConcatSupport(Boolean httpConcatSupport) {
        this.httpConcatSupport = httpConcatSupport;
    }
}

