/*
 * Decompiled with CFR 0.152.
 */
package com.feilong.taglib.display.breadcrumb;

import com.feilong.core.Validate;
import com.feilong.core.Validator;
import com.feilong.core.bean.ConvertUtil;
import com.feilong.core.net.URIUtil;
import com.feilong.core.net.URLUtil;
import com.feilong.core.util.AggregateUtil;
import com.feilong.core.util.CollectionsUtil;
import com.feilong.json.JsonUtil;
import com.feilong.taglib.display.breadcrumb.command.BreadCrumbEntity;
import com.feilong.taglib.display.breadcrumb.command.BreadCrumbParams;
import com.feilong.taglib.display.breadcrumb.command.BreadCrumbVMParams;
import com.feilong.template.TemplateUtil;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BreadCrumbUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(BreadCrumbUtil.class);
    private static final String VM_KEY_BREADCRUMB = "breadCrumbVMParams";

    private BreadCrumbUtil() {
        throw new AssertionError((Object)("No " + this.getClass().getName() + " instances for you!"));
    }

    public static String getBreadCrumbContent(BreadCrumbParams breadCrumbParams) {
        List currentBreadCrumbEntityTreeList;
        Validate.notNull(breadCrumbParams, "breadCrumbParams can't be null!", new Object[0]);
        List breadCrumbEntityList = breadCrumbParams.getBreadCrumbEntityList();
        Validate.notEmpty(breadCrumbEntityList, "breadCrumbEntityList can't be null/empty!", new Object[0]);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("input breadCrumbParams info:[{}]", (Object)JsonUtil.format(breadCrumbParams));
        }
        if (Validator.isNullOrEmpty(currentBreadCrumbEntityTreeList = BreadCrumbUtil.lookUpCurrentBreadCrumbEntityTreeList(breadCrumbParams))) {
            return "";
        }
        currentBreadCrumbEntityTreeList = BreadCrumbUtil.restructureBreadCrumbEntityTreeListPath(currentBreadCrumbEntityTreeList, breadCrumbParams.getUrlPrefix());
        BreadCrumbVMParams breadCrumbVMParams = new BreadCrumbVMParams();
        breadCrumbVMParams.setBreadCrumbEntityList(currentBreadCrumbEntityTreeList);
        breadCrumbVMParams.setConnector(breadCrumbParams.getConnector());
        Map contextKeyValues = ConvertUtil.toMap(VM_KEY_BREADCRUMB, breadCrumbVMParams);
        String siteMapString = TemplateUtil.parseTemplate(breadCrumbParams.getVmPath(), contextKeyValues);
        LOGGER.debug("siteMapString is:[{}]", (Object)siteMapString);
        return siteMapString;
    }

    private static List<BreadCrumbEntity<Object>> restructureBreadCrumbEntityTreeListPath(List<BreadCrumbEntity<Object>> currentBreadCrumbEntityTreeList, String urlPrefix) {
        if (Validator.isNullOrEmpty(urlPrefix)) {
            return currentBreadCrumbEntityTreeList;
        }
        for (BreadCrumbEntity<Object> breadCrumbEntity : currentBreadCrumbEntityTreeList) {
            String path = breadCrumbEntity.getPath();
            if (URIUtil.create(path).isAbsolute()) continue;
            breadCrumbEntity.setPath(URLUtil.getUnionUrl(URLUtil.toURL(urlPrefix), path));
        }
        return currentBreadCrumbEntityTreeList;
    }

    private static <T> List<BreadCrumbEntity<T>> lookUpCurrentBreadCrumbEntityTreeList(BreadCrumbParams breadCrumbParams) {
        String currentPath = breadCrumbParams.getCurrentPath();
        List breadCrumbEntityList = breadCrumbParams.getBreadCrumbEntityList();
        if (Validator.isNullOrEmpty(currentPath)) {
            Map groupCount = AggregateUtil.groupCount(breadCrumbEntityList, "parentId");
            for (Map.Entry entry : groupCount.entrySet()) {
                Integer value = entry.getValue();
                Validate.isTrue(value <= 1, "currentPath isNullOrEmpty,but breadCrumbEntityList has repeat parentId data!", new Object[0]);
            }
            return BreadCrumbUtil.sortOutAllParentBreadCrumbEntityList(breadCrumbEntityList);
        }
        BreadCrumbEntity currentBreadCrumbEntity = BreadCrumbUtil.getBreadCrumbEntityByPath(currentPath, breadCrumbEntityList);
        if (Validator.isNullOrEmpty(currentBreadCrumbEntity)) {
            if (LOGGER.isWarnEnabled()) {
                LOGGER.warn("when currentPath:{},in breadCrumbEntityList:[{}],can't find", (Object)currentPath, (Object)JsonUtil.format(breadCrumbParams));
            }
            return Collections.emptyList();
        }
        return BreadCrumbUtil.sortOutAllParentBreadCrumbEntityList(currentBreadCrumbEntity, breadCrumbEntityList);
    }

    private static <T> List<BreadCrumbEntity<T>> sortOutAllParentBreadCrumbEntityList(List<BreadCrumbEntity<T>> breadCrumbEntityList) {
        BreadCrumbEntity<T> currentBreadCrumbEntity = null;
        return BreadCrumbUtil.sortOutAllParentBreadCrumbEntityList(currentBreadCrumbEntity, breadCrumbEntityList);
    }

    private static <T> List<BreadCrumbEntity<T>> sortOutAllParentBreadCrumbEntityList(BreadCrumbEntity<T> currentBreadCrumbEntity, List<BreadCrumbEntity<T>> breadCrumbEntityList) {
        if (null == currentBreadCrumbEntity) {
            return breadCrumbEntityList;
        }
        List<BreadCrumbEntity<T>> allParentBreadCrumbEntityList = CollectionsUtil.newArrayList();
        allParentBreadCrumbEntityList = BreadCrumbUtil.constructParentBreadCrumbEntityList(currentBreadCrumbEntity, breadCrumbEntityList, allParentBreadCrumbEntityList);
        LOGGER.info("before Collections.reverse,allParentBreadCrumbEntityList size:{}", (Object)allParentBreadCrumbEntityList.size());
        Collections.reverse(allParentBreadCrumbEntityList);
        return allParentBreadCrumbEntityList;
    }

    private static <T> List<BreadCrumbEntity<T>> constructParentBreadCrumbEntityList(BreadCrumbEntity<T> breadCrumbEntity, List<BreadCrumbEntity<T>> siteMapEntities, List<BreadCrumbEntity<T>> allParentBreadCrumbEntityList) {
        allParentBreadCrumbEntityList.add(breadCrumbEntity);
        T parentId = breadCrumbEntity.getParentId();
        for (BreadCrumbEntity<T> loopBreadCrumbEntity : siteMapEntities) {
            if (!loopBreadCrumbEntity.getId().equals(parentId)) continue;
            LOGGER.debug("loopBreadCrumbEntity.getId():{},breadCrumbEntity_in.getParentId():{}", loopBreadCrumbEntity.getId(), parentId);
            BreadCrumbUtil.constructParentBreadCrumbEntityList(loopBreadCrumbEntity, siteMapEntities, allParentBreadCrumbEntityList);
            break;
        }
        return allParentBreadCrumbEntityList;
    }

    private static <T> BreadCrumbEntity<T> getBreadCrumbEntityByPath(String currentPath, List<BreadCrumbEntity<T>> breadCrumbEntityList) {
        for (BreadCrumbEntity<T> breadCrumbEntity : breadCrumbEntityList) {
            if (!breadCrumbEntity.getPath().equals(currentPath)) continue;
            return breadCrumbEntity;
        }
        LOGGER.warn("currentPath is :{},can't find match BreadCrumbEntity", (Object)currentPath);
        return null;
    }
}

