/*
 * Decompiled with CFR 0.152.
 */
package com.feilong.taglib;

import com.feilong.core.Validator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SimpleTagStringCacheManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(SimpleTagStringCacheManager.class);
    private static final boolean CACHE_ENABLE = true;
    private static final Map<String, Object> CACHE = new ConcurrentHashMap<String, Object>();

    private SimpleTagStringCacheManager() {
        throw new AssertionError((Object)("No " + this.getClass().getName() + " instances for you!"));
    }

    public static Object get(String key) {
        int size = CACHE.size();
        if (CACHE.containsKey(key)) {
            LOGGER.debug("cacheSize:[{}],key:[{}],hit cache,get from cache", (Object)size, (Object)key);
            return CACHE.get(key);
        }
        LOGGER.debug("cacheSize:[{}],not contains [{}],will do parse", (Object)size, (Object)key);
        return null;
    }

    public static void put(String cacheParam, Object content) {
        if (Validator.isNotNullOrEmpty(content)) {
            CACHE.put(cacheParam, content);
        }
    }
}

