/*
 * Decompiled with CFR 0.152.
 */
package com.feilong.spring.web.util;

import com.feilong.core.Validate;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.springframework.context.ApplicationContext;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.springframework.web.context.support.WebApplicationContextUtils;
import org.springframework.web.servlet.support.RequestContextUtils;

public final class WebSpringUtil {
    private WebSpringUtil() {
        throw new AssertionError((Object)("No " + this.getClass().getName() + " instances for you!"));
    }

    public static HttpServletRequest getRequest() {
        ServletRequestAttributes servletRequestAttributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        return servletRequestAttributes.getRequest();
    }

    public static <T> T getBean(HttpServletRequest request, String beanName) {
        WebApplicationContext webApplicationContext = WebSpringUtil.getWebApplicationContext(request);
        return WebSpringUtil.getBean((ApplicationContext)webApplicationContext, beanName);
    }

    public static <T> T getBean(HttpServletRequest request, Class<T> requiredType) {
        WebApplicationContext webApplicationContext = WebSpringUtil.getWebApplicationContext(request);
        return WebSpringUtil.getBean((ApplicationContext)webApplicationContext, requiredType);
    }

    public static <T> T getBean(ServletContext servletContext, String beanName) {
        WebApplicationContext webApplicationContext = WebSpringUtil.getWebApplicationContext(servletContext);
        return WebSpringUtil.getBean((ApplicationContext)webApplicationContext, beanName);
    }

    public static <T> T getBean(ServletContext servletContext, Class<T> requiredType) {
        WebApplicationContext webApplicationContext = WebSpringUtil.getWebApplicationContext(servletContext);
        return WebSpringUtil.getBean((ApplicationContext)webApplicationContext, requiredType);
    }

    public static <T> T getRequiredBean(ServletContext servletContext, String beanName) {
        WebApplicationContext webApplicationContext = WebSpringUtil.getRequiredWebApplicationContext(servletContext);
        return WebSpringUtil.getBean((ApplicationContext)webApplicationContext, beanName);
    }

    public static <T> T getRequiredBean(ServletContext servletContext, Class<T> requiredType) {
        WebApplicationContext webApplicationContext = WebSpringUtil.getRequiredWebApplicationContext(servletContext);
        return WebSpringUtil.getBean((ApplicationContext)webApplicationContext, requiredType);
    }

    private static <T> T getBean(ApplicationContext applicationContext, String beanName) {
        return (T)applicationContext.getBean(beanName);
    }

    private static <T> T getBean(ApplicationContext applicationContext, Class<T> requiredType) {
        return (T)applicationContext.getBean(requiredType);
    }

    public static WebApplicationContext getWebApplicationContext(ServletContext servletContext) {
        return WebApplicationContextUtils.getWebApplicationContext((ServletContext)servletContext);
    }

    public static WebApplicationContext getRequiredWebApplicationContext(ServletContext servletContext) {
        return WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)servletContext);
    }

    public static WebApplicationContext getWebApplicationContext(HttpServletRequest request) {
        Validate.notNull(request, "request can't be null!", new Object[0]);
        ServletContext servletContext = request.getServletContext();
        Validate.notNull(servletContext, "servletContext can't be null!,request class is:[%s]", request.getClass().getName());
        return RequestContextUtils.findWebApplicationContext((HttpServletRequest)request, (ServletContext)servletContext);
    }
}

