/*
 * Decompiled with CFR 0.152.
 */
package com.feilong.servlet.http.listener;

import com.feilong.json.JsonUtil;
import com.feilong.servlet.http.SessionUtil;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpSessionLoggingListener
implements HttpSessionListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpSessionLoggingListener.class);

    public void sessionCreated(HttpSessionEvent httpSessionEvent) {
        if (LOGGER.isDebugEnabled()) {
            HttpSession session = httpSessionEvent.getSession();
            LOGGER.debug("session [created],source:[{}],info:{}", httpSessionEvent.getSource(), (Object)JsonUtil.format(SessionUtil.getSessionInfoMapForLog(session)));
        }
    }

    public void sessionDestroyed(HttpSessionEvent httpSessionEvent) {
        if (LOGGER.isDebugEnabled()) {
            HttpSession session = httpSessionEvent.getSession();
            LOGGER.debug("session [destroyed],source:[{}],info:{}", httpSessionEvent.getSource(), (Object)JsonUtil.format(SessionUtil.getSessionInfoMapForLog(session)));
        }
    }
}

