/*
 * Decompiled with CFR 0.152.
 */
package com.feilong.servlet.http;

import com.feilong.core.Validate;
import com.feilong.core.Validator;
import com.feilong.core.bean.ConvertUtil;
import com.feilong.core.date.DateUtil;
import com.feilong.core.util.MapUtil;
import com.feilong.core.util.SortUtil;
import com.feilong.tools.slf4j.Slf4jUtil;
import java.io.Serializable;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SessionUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(SessionUtil.class);

    private SessionUtil() {
        throw new AssertionError((Object)("No " + this.getClass().getName() + " instances for you!"));
    }

    public static String getSessionId(HttpServletRequest request) {
        Validate.notNull(request, "request can't be null!", new Object[0]);
        HttpSession session = request.getSession(false);
        return session == null ? null : session.getId();
    }

    public static <T> T getAttribute(HttpServletRequest request, String attributeName) {
        Validate.notNull(request, "request can't be null!", new Object[0]);
        HttpSession session = request.getSession(false);
        return (T)(session == null ? null : session.getAttribute(attributeName));
    }

    public static <T> T getRequiredAttribute(HttpServletRequest request, String attributeName) {
        T value = SessionUtil.getAttribute(request, attributeName);
        Validate.validState(null != value, "No session attribute [%s] found", attributeName);
        return value;
    }

    public static void setAttribute(HttpServletRequest request, String attributeName, Serializable attributeValue) {
        Validate.notNull(request, "request can't be null!", new Object[0]);
        if (attributeValue == null) {
            HttpSession session = request.getSession(false);
            if (session != null) {
                session.removeAttribute(attributeName);
            }
            return;
        }
        request.getSession().setAttribute(attributeName, (Object)attributeValue);
    }

    public static void removeAttribute(HttpServletRequest request, String attributeName) {
        Validate.notNull(request, "request can't be null!", new Object[0]);
        HttpSession session = request.getSession(false);
        if (null == session) {
            return;
        }
        session.removeAttribute(attributeName);
    }

    public static Map<String, Object> getSessionInfoMapForLog(HttpSession session) {
        if (Validator.isNullOrEmpty(session)) {
            return Collections.emptyMap();
        }
        Map<String, Object> map = MapUtil.newLinkedHashMap();
        map.put("id", session.getId());
        map.put("isNew", session.isNew());
        map.put("creationTime", SessionUtil.toPrettyMessage(session.getCreationTime()));
        map.put("lastAccessedTime", SessionUtil.toPrettyMessage(session.getLastAccessedTime()));
        int maxInactiveInterval = session.getMaxInactiveInterval();
        map.put("maxInactiveInterval", DateUtil.formatDuration(1000L * (long)maxInactiveInterval));
        map.put("attributeNames", SortUtil.sortList(ConvertUtil.toList(session.getAttributeNames())));
        return map;
    }

    public static Map<String, Serializable> getAttributeMap(HttpSession session) {
        Map<String, Serializable> map = MapUtil.newHashMap();
        Enumeration attributeNames = session.getAttributeNames();
        while (attributeNames.hasMoreElements()) {
            String name = (String)attributeNames.nextElement();
            map.put(name, (Serializable)session.getAttribute(name));
        }
        return map;
    }

    public static HttpSession replaceSession(HttpServletRequest request) {
        HttpSession oldSession = request.getSession(false);
        if (null == oldSession) {
            LOGGER.debug("oldSession is null,return a new session~~");
            return request.getSession();
        }
        String oldSessionId = oldSession.getId();
        Map<String, Serializable> attributeMap = SessionUtil.getAttributeMap(oldSession);
        oldSession.invalidate();
        HttpSession newSession = request.getSession();
        for (Map.Entry<String, Serializable> entry : attributeMap.entrySet()) {
            newSession.setAttribute(entry.getKey(), (Object)entry.getValue());
        }
        LOGGER.debug("old sessionId:[{}],invalidate it!new session:[{}],and put all attributes", (Object)oldSessionId, (Object)newSession.getId());
        return newSession;
    }

    private static String toPrettyMessage(long creationTime) {
        Date creationTimeDate = new Date(creationTime);
        String dateString = DateUtil.toString(creationTimeDate, "yyyy-MM-dd HH:mm:ss.SSS");
        return Slf4jUtil.format("[{}],intervalToNow:[{}]", dateString, DateUtil.formatDuration(creationTimeDate));
    }
}

