/*
 * Decompiled with CFR 0.152.
 */
package com.feilong.servlet.http;

import com.feilong.core.CharsetType;
import com.feilong.core.Validate;
import com.feilong.core.Validator;
import com.feilong.core.util.MapUtil;
import com.feilong.io.entity.MimeType;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UncheckedIOException;
import java.util.Collection;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ResponseUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(ResponseUtil.class);

    private ResponseUtil() {
        throw new AssertionError((Object)("No " + this.getClass().getName() + " instances for you!"));
    }

    public static void sendRedirect(HttpServletResponse response, String url) {
        Validate.notBlank(url, "url can't be blank!", new Object[0]);
        try {
            LOGGER.debug("response sendRedirect to:[{}]", (Object)url);
            response.sendRedirect(url);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static void sendError(HttpServletResponse response, int errorStatusCode) {
        ResponseUtil.sendError(response, errorStatusCode, "");
    }

    public static void sendError(HttpServletResponse response, int errorStatusCode, String errorMessage) {
        Validate.notNull(errorMessage, "errorMessage can't be null!", new Object[0]);
        try {
            LOGGER.debug("will sendError,errorStatusCode:[{}],errorMessage:[{}]", (Object)errorStatusCode, (Object)errorMessage);
            response.sendError(errorStatusCode, errorMessage);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static void setNoCacheHeader(HttpServletResponse response) {
        response.setHeader("Cache-Control", "no-cache,no-store,max-age=0");
        response.setHeader("Pragma", "no-cache,no-store");
        response.setDateHeader("Expires", -1L);
    }

    public static void setCacheHeader(HttpServletResponse response, int cacheTime) {
        if (cacheTime <= 0) {
            ResponseUtil.setNoCacheHeader(response);
        } else {
            response.setHeader("Cache-Control", "max-age=" + cacheTime);
        }
    }

    public static void writeText(HttpServletResponse response, Object text) {
        ResponseUtil.writeText(response, text, CharsetType.UTF8);
    }

    public static void writeText(HttpServletResponse response, Object text, String characterEncoding) {
        Validate.notBlank(characterEncoding, "characterEncoding can't be blank!", new Object[0]);
        String contentType = MimeType.TXT.getMime() + ";charset=" + characterEncoding;
        ResponseUtil.write(response, text, contentType, characterEncoding);
    }

    public static void writeJson(HttpServletResponse response, Object json) {
        ResponseUtil.writeJson(response, json, CharsetType.UTF8);
    }

    public static void writeJson(HttpServletResponse response, Object json, String characterEncoding) {
        Validate.notBlank(characterEncoding, "characterEncoding can't be blank!", new Object[0]);
        String contentType = MimeType.JSON.getMime() + ";charset=" + characterEncoding;
        ResponseUtil.write(response, json, contentType, characterEncoding);
    }

    public static void write(HttpServletResponse response, Object content) {
        String contentType = null;
        String characterEncoding = null;
        ResponseUtil.write(response, content, contentType, characterEncoding);
    }

    public static void write(HttpServletResponse response, Object content, String contentType, String characterEncoding) {
        if (Validator.isNotNullOrEmpty(contentType)) {
            response.setContentType(contentType);
        }
        if (Validator.isNotNullOrEmpty(characterEncoding)) {
            response.setCharacterEncoding(characterEncoding);
        }
        try {
            PrintWriter printWriter = response.getWriter();
            printWriter.print(content);
            printWriter.flush();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static Map<String, Object> getResponseInfoMapForLog(HttpServletResponse response) {
        Map<String, Object> map = MapUtil.newLinkedHashMap();
        map.put("response.getBufferSize()", response.getBufferSize());
        map.put("response.getCharacterEncoding()", response.getCharacterEncoding());
        map.put("response.getContentType()", response.getContentType());
        map.put("response headers", ResponseUtil.getResponseHeaderMap(response));
        map.put("response.getLocale()", "" + response.getLocale());
        return map;
    }

    private static Map<String, Object> getResponseHeaderMap(HttpServletResponse response) {
        Collection headerNames = response.getHeaderNames();
        Map<String, Object> map = MapUtil.newHashMap();
        for (String headerName : headerNames) {
            map.put(headerName, response.getHeader(headerName));
        }
        return map;
    }
}

