/*
 * Decompiled with CFR 0.152.
 */
package com.feilong.servlet.http;

import com.feilong.core.CharsetType;
import com.feilong.core.Validator;
import com.feilong.core.date.DateUtil;
import com.feilong.core.net.URIUtil;
import com.feilong.io.FileUtil;
import com.feilong.io.IOWriteUtil;
import com.feilong.io.MimeTypeUtil;
import com.feilong.io.entity.MimeType;
import com.feilong.lib.lang3.StringUtils;
import com.feilong.servlet.http.RequestUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.util.Date;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ResponseDownloadUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(ResponseDownloadUtil.class);

    private ResponseDownloadUtil() {
        throw new AssertionError((Object)("No " + this.getClass().getName() + " instances for you!"));
    }

    public static void download(String pathname, HttpServletRequest request, HttpServletResponse response) {
        ResponseDownloadUtil.download(new File(pathname), request, response);
    }

    public static void download(File file, HttpServletRequest request, HttpServletResponse response) {
        String saveFileName = file.getName();
        FileInputStream inputStream = FileUtil.getFileInputStream(file);
        long contentLength = FileUtil.getFileSize(file);
        ResponseDownloadUtil.download(saveFileName, inputStream, contentLength, request, response);
    }

    public static void download(String saveFileName, InputStream inputStream, Number contentLength, HttpServletRequest request, HttpServletResponse response) {
        String contentType = null;
        String contentDisposition = null;
        ResponseDownloadUtil.download(saveFileName, inputStream, contentLength, contentType, contentDisposition, request, response);
    }

    public static void download(String saveFileName, InputStream inputStream, Number contentLength, String contentType, String contentDisposition, HttpServletRequest request, HttpServletResponse response) {
        ResponseDownloadUtil.setDownloadResponseHeader(saveFileName, contentLength, contentType, contentDisposition, response);
        ResponseDownloadUtil.downLoadData(saveFileName, inputStream, contentLength, request, response);
    }

    private static void downLoadData(String saveFileName, InputStream inputStream, Number contentLength, HttpServletRequest request, HttpServletResponse response) {
        Date beginDate = DateUtil.now();
        String length = FileUtil.formatSize(contentLength.longValue());
        LOGGER.info("begin download~~,saveFileName:[{}],contentLength:[{}]", (Object)saveFileName, (Object)length);
        try {
            ServletOutputStream outputStream = response.getOutputStream();
            IOWriteUtil.write(inputStream, (OutputStream)outputStream);
            if (LOGGER.isInfoEnabled()) {
                String pattern = "end download,saveFileName:[{}],contentLength:[{}],time use:[{}]";
                LOGGER.info(pattern, new Object[]{saveFileName, length, DateUtil.formatDuration(beginDate)});
            }
        }
        catch (IOException e) {
            String exceptionName = e.getClass().getName();
            if (StringUtils.contains((CharSequence)exceptionName, "ClientAbortException") || StringUtils.contains((CharSequence)e.getMessage(), "ClientAbortException")) {
                String pattern = "[ClientAbortException],maybe user use Thunder soft or abort client soft download,exceptionName:[{}],exception message:[{}] ,request User-Agent:[{}]";
                LOGGER.warn(pattern, new Object[]{exceptionName, e.getMessage(), RequestUtil.getHeaderUserAgent(request)});
            }
            LOGGER.error("[download exception],exception name: " + exceptionName, (Throwable)e);
            throw new UncheckedIOException(e);
        }
    }

    private static void setDownloadResponseHeader(String saveFileName, Number contentLength, String contentType, String contentDisposition, HttpServletResponse response) {
        response.reset();
        response.addHeader("Content-Disposition", ResponseDownloadUtil.resolverContentDisposition(saveFileName, contentDisposition));
        response.setContentType(ResponseDownloadUtil.resolverContentType(saveFileName, contentType));
        if (Validator.isNotNullOrEmpty(contentLength)) {
            response.setContentLength(contentLength.intValue());
        }
    }

    private static String resolverContentDisposition(String saveFileName, String contentDisposition) {
        return Validator.isNotNullOrEmpty(contentDisposition) ? contentDisposition : "attachment; filename=" + URIUtil.encode(saveFileName, CharsetType.UTF8);
    }

    private static String resolverContentType(String saveFileName, String inputContentType) {
        if (Validator.isNotNullOrEmpty(inputContentType)) {
            return inputContentType;
        }
        String contentTypeByFileName = MimeTypeUtil.getContentTypeByFileName(saveFileName);
        return Validator.isNotNullOrEmpty(contentTypeByFileName) ? contentTypeByFileName : MimeType.BIN.getMime();
    }
}

