/*
 * Decompiled with CFR 0.152.
 */
package com.feilong.servlet.http;

import com.feilong.core.Validate;
import com.feilong.core.Validator;
import com.feilong.core.bean.PropertyUtil;
import com.feilong.json.JsonUtil;
import com.feilong.servlet.http.entity.CookieEntity;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CookieUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(CookieUtil.class);

    private CookieUtil() {
        throw new AssertionError((Object)("No " + this.getClass().getName() + " instances for you!"));
    }

    public static String getCookieValue(HttpServletRequest request, String cookieName) {
        Cookie cookie = CookieUtil.getCookie(request, cookieName);
        return null == cookie ? null : CookieUtil.getReadValue(cookie);
    }

    public static Cookie getCookie(HttpServletRequest request, String cookieName) {
        Cookie[] cookies = request.getCookies();
        if (Validator.isNullOrEmpty(cookies)) {
            LOGGER.debug("when get cookieName:[{}],but request's cookies is null or empty!!", (Object)cookieName);
            return null;
        }
        for (Cookie cookie : cookies) {
            if (!cookie.getName().equals(cookieName)) continue;
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("[getCookie],cookieName:[{}],cookie info:[{}]", (Object)cookieName, (Object)JsonUtil.format(cookie, 0, 0));
            }
            return cookie;
        }
        LOGGER.debug("can't find the cookie:[{}]", (Object)cookieName);
        return null;
    }

    public static Map<String, String> getCookieMap(HttpServletRequest request) {
        Cookie[] cookies = request.getCookies();
        if (Validator.isNullOrEmpty(cookies)) {
            return Collections.emptyMap();
        }
        TreeMap<String, String> map = new TreeMap<String, String>();
        for (Cookie cookie : cookies) {
            map.put(cookie.getName(), CookieUtil.getReadValue(cookie));
        }
        return map;
    }

    public static void deleteCookie(String cookieName, HttpServletResponse response) {
        CookieUtil.deleteCookie(new CookieEntity(cookieName, ""), response);
    }

    public static void deleteCookie(CookieEntity cookieEntity, HttpServletResponse response) {
        Validate.notNull(cookieEntity, "cookieEntity can't be null!", new Object[0]);
        cookieEntity.setMaxAge(0);
        CookieUtil.addCookie(cookieEntity, response);
        LOGGER.debug("[deleteCookie],cookieName:[{}]", (Object)cookieEntity.getName());
    }

    public static void addCookie(String cookieName, String value, HttpServletResponse response) {
        Validate.notBlank(cookieName, "cookieName can't be null/empty!", new Object[0]);
        CookieUtil.addCookie(new CookieEntity(cookieName, value), response);
    }

    public static void addCookie(String cookieName, String value, int maxAge, HttpServletResponse response) {
        Validate.notBlank(cookieName, "cookieName can't be null/empty!", new Object[0]);
        CookieUtil.addCookie(new CookieEntity(cookieName, value, maxAge), response);
    }

    public static void addCookie(CookieEntity cookieEntity, HttpServletResponse response) {
        CookieUtil.validateCookieEntity(cookieEntity);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("[addCookie],cookieName:[{}],cookieEntity info:[{}]", (Object)cookieEntity.getName(), (Object)JsonUtil.format(cookieEntity, 0, 0));
        }
        response.addCookie(CookieUtil.toCookie(cookieEntity));
    }

    private static Cookie toCookie(CookieEntity cookieEntity) {
        Cookie cookie = new Cookie(cookieEntity.getName(), CookieUtil.resolveWriteValue(cookieEntity));
        PropertyUtil.copyProperties(cookie, cookieEntity, "maxAge", "secure", "version", "httpOnly");
        PropertyUtil.setPropertyIfValueNotNullOrEmpty(cookie, "comment", cookieEntity.getComment());
        PropertyUtil.setPropertyIfValueNotNullOrEmpty(cookie, "domain", cookieEntity.getDomain());
        PropertyUtil.setPropertyIfValueNotNullOrEmpty(cookie, "path", cookieEntity.getPath());
        return cookie;
    }

    private static void validateCookieEntity(CookieEntity cookieEntity) {
        String value;
        Validate.notNull(cookieEntity, "cookieEntity can't be null!", new Object[0]);
        Validate.notBlank(cookieEntity.getName(), "cookieName can't be null/empty!", new Object[0]);
        if (LOGGER.isWarnEnabled() && Validator.isNotNullOrEmpty(value = CookieUtil.resolveWriteValue(cookieEntity)) && value.length() > 4000) {
            String pattern = "cookie value:{},length:{},more than [4000]!!!some browser may be not support!!!!!,cookieEntity info :{}";
            LOGGER.warn(pattern, new Object[]{value, value.length(), JsonUtil.format(cookieEntity, 0, 0)});
        }
    }

    private static String resolveWriteValue(CookieEntity cookieEntity) {
        return cookieEntity.getValue();
    }

    private static String getReadValue(Cookie cookie) {
        return cookie.getValue();
    }
}

