/*
 * Decompiled with CFR 0.152.
 */
package com.feilong.security.symmetric;

import com.feilong.core.CharsetType;
import com.feilong.core.Validate;
import com.feilong.core.lang.ObjectUtil;
import com.feilong.core.lang.StringUtil;
import com.feilong.lib.codec.binary.Base64;
import com.feilong.security.ByteUtil;
import com.feilong.security.EncryptionException;
import com.feilong.security.symmetric.CipherMode;
import com.feilong.security.symmetric.CipherPadding;
import com.feilong.security.symmetric.CipherUtil;
import com.feilong.security.symmetric.LogBuilder;
import com.feilong.security.symmetric.SymmetricType;
import com.feilong.security.symmetric.builder.DefaultKeyBuilder;
import com.feilong.security.symmetric.builder.KeyBuilder;
import com.feilong.security.symmetric.builder.TransformationBuilder;
import java.security.Key;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SymmetricEncryption {
    private static final Logger LOGGER = LoggerFactory.getLogger(SymmetricEncryption.class);
    private SymmetricType symmetricType;
    private String keyString;
    private KeyBuilder keyBuilder;
    private CipherMode cipherMode;
    private CipherPadding cipherPadding;

    public SymmetricEncryption() {
    }

    public SymmetricEncryption(SymmetricType symmetricType) {
        this.symmetricType = symmetricType;
    }

    public SymmetricEncryption(SymmetricType symmetricType, String keyString) {
        this.symmetricType = symmetricType;
        this.keyString = keyString;
    }

    public SymmetricEncryption(SymmetricType symmetricType, String keyString, KeyBuilder keyBuilder) {
        this.symmetricType = symmetricType;
        this.keyString = keyString;
        this.keyBuilder = keyBuilder;
    }

    public SymmetricEncryption(SymmetricType symmetricType, String keyString, CipherMode cipherMode, CipherPadding cipherPadding) {
        this.symmetricType = symmetricType;
        this.keyString = keyString;
        this.cipherMode = cipherMode;
        this.cipherPadding = cipherPadding;
    }

    public SymmetricEncryption(SymmetricType symmetricType, String keyString, KeyBuilder keyBuilder, CipherMode cipherMode, CipherPadding cipherPadding) {
        this.symmetricType = symmetricType;
        this.keyString = keyString;
        this.keyBuilder = keyBuilder;
        this.cipherMode = cipherMode;
        this.cipherPadding = cipherPadding;
    }

    public String encryptBase64(String original) {
        return this.encryptBase64(original, CharsetType.UTF8);
    }

    public String encryptBase64(String original, String charsetName) {
        Validate.notBlank(charsetName, "charsetName can't be blank!", new Object[0]);
        try {
            byte[] encryptBytes = this.toEncryptBytes(original, charsetName);
            String value = Base64.encodeBase64String(encryptBytes);
            LogBuilder.logEncrypt("encrypBase64", original, value, this.symmetricType.getAlgorithm(), this.keyString);
            return value;
        }
        catch (Exception e) {
            throw new EncryptionException(LogBuilder.errorMessage("original", original, this.symmetricType.getAlgorithm(), this.keyString, charsetName), e);
        }
    }

    public String decryptBase64(String base64String) {
        return this.decryptBase64(base64String, CharsetType.UTF8);
    }

    public String decryptBase64(String base64String, String charsetName) {
        Validate.notBlank(charsetName, "charsetName can't be blank!", new Object[0]);
        try {
            byte[] byteMi = Base64.decodeBase64(base64String);
            String original = this.toDecryptString(byteMi, charsetName);
            LogBuilder.logDecrypt("base64String", base64String, original, this.symmetricType.getAlgorithm(), this.keyString);
            return original;
        }
        catch (Exception e) {
            throw new EncryptionException(LogBuilder.errorMessage("base64String", base64String, this.symmetricType.getAlgorithm(), this.keyString, charsetName), e);
        }
    }

    public String encryptHex(String original) {
        return this.encryptHex(original, CharsetType.UTF8);
    }

    public String encryptHex(String original, String charsetName) {
        Validate.notBlank(charsetName, "charsetName can't be blank!", new Object[0]);
        try {
            byte[] encryptBytes = this.toEncryptBytes(original, charsetName);
            String value = ByteUtil.bytesToHexStringUpperCase(encryptBytes);
            LogBuilder.logEncrypt("hexStringUpperCase", original, value, this.symmetricType.getAlgorithm(), this.keyString);
            return value;
        }
        catch (Exception e) {
            throw new EncryptionException(LogBuilder.errorMessage("original", original, this.symmetricType.getAlgorithm(), this.keyString, charsetName), e);
        }
    }

    public String decryptHex(String hexString) {
        return this.decryptHex(hexString, CharsetType.UTF8);
    }

    public String decryptHex(String hexString, String charsetName) {
        Validate.notBlank(charsetName, "charsetName can't be blank!", new Object[0]);
        try {
            byte[] bs = ByteUtil.hexBytesToBytes(StringUtil.getBytes(hexString, charsetName));
            String original = this.toDecryptString(bs, charsetName);
            LogBuilder.logDecrypt("hexString", hexString, original, this.symmetricType.getAlgorithm(), this.keyString);
            return original;
        }
        catch (Exception e) {
            throw new EncryptionException(LogBuilder.errorMessage("hexString", hexString, this.symmetricType.getAlgorithm(), this.keyString, charsetName), e);
        }
    }

    private byte[] toEncryptBytes(String original, String charsetName) {
        byte[] bs = StringUtil.getBytes(original, charsetName);
        return CipherUtil.encrypt(bs, this.buildTransformation(), this.buildKey());
    }

    private String toDecryptString(byte[] bs, String charsetName) {
        byte[] decryptBytes = CipherUtil.decrypt(bs, this.buildTransformation(), this.buildKey());
        return StringUtil.newString(decryptBytes, charsetName);
    }

    private String buildTransformation() {
        String transformation = TransformationBuilder.build(this.symmetricType.getAlgorithm(), this.cipherMode, this.cipherPadding);
        LOGGER.debug("algorithm:[{}],keyString:[{}],transformation:[{}]", new Object[]{this.symmetricType.getAlgorithm(), this.keyString, transformation});
        return transformation;
    }

    private Key buildKey() {
        KeyBuilder useKeyBuilder = ObjectUtil.defaultIfNull(this.keyBuilder, DefaultKeyBuilder.INSTANCE);
        return useKeyBuilder.build(this.symmetricType.getAlgorithm(), this.keyString);
    }

    public void setKeyString(String keyString) {
        this.keyString = keyString;
    }

    public void setKeyBuilder(KeyBuilder keyBuilder) {
        this.keyBuilder = keyBuilder;
    }

    public void setCipherMode(CipherMode cipherMode) {
        this.cipherMode = cipherMode;
    }

    public void setCipherPadding(CipherPadding cipherPadding) {
        this.cipherPadding = cipherPadding;
    }

    public void setSymmetricType(SymmetricType symmetricType) {
        this.symmetricType = symmetricType;
    }
}

